/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.IOException;
import org.restlet.engine.http.HttpUtils;

public class HeaderReader {
    private final String header;
    private int index;

    public HeaderReader(String header) {
        this.header = header;
        this.index = header == null || header.length() == 0 ? -1 : 0;
    }

    protected void appendQuotedString(Appendable buffer) throws IOException {
        boolean done = false;
        boolean quotedPair = false;
        int nextChar = 0;
        while (!done && nextChar != -1) {
            nextChar = this.read();
            if (quotedPair) {
                if (HttpUtils.isText(nextChar)) {
                    buffer.append((char)nextChar);
                    quotedPair = false;
                    continue;
                }
                throw new IOException("Invalid character detected in quoted string. Please check your value");
            }
            if (HttpUtils.isDoubleQuote(nextChar)) {
                done = true;
                continue;
            }
            if (nextChar == 92) {
                quotedPair = true;
                continue;
            }
            if (HttpUtils.isText(nextChar)) {
                buffer.append((char)nextChar);
                continue;
            }
            throw new IOException("Invalid character detected in quoted string. Please check your value");
        }
    }

    protected boolean isLinearWhiteSpace(int character) {
        return HttpUtils.isCarriageReturn(character) || HttpUtils.isSpace(character) || HttpUtils.isLineFeed(character) || HttpUtils.isHorizontalTab(character);
    }

    protected boolean isValueSeparator(int character) {
        return character == 44;
    }

    public int read() {
        int result = -1;
        if (this.index != -1) {
            result = this.header.charAt(this.index++);
            if (this.index >= this.header.length()) {
                this.index = -1;
            }
        }
        return result;
    }

    protected String readQuotedString() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendQuotedString(sb);
        return sb.toString();
    }

    public String readValue() {
        StringBuilder sb = null;
        int next = this.read();
        while (next != -1 && this.isLinearWhiteSpace(next)) {
            next = this.read();
        }
        while (next != -1 && !this.isValueSeparator(next)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append((char)next);
            next = this.read();
        }
        if (sb != null) {
            for (int i = sb.length() - 1; i >= 0 && this.isLinearWhiteSpace(sb.charAt(i)); --i) {
                sb.deleteCharAt(i);
            }
        }
        return sb == null ? null : sb.toString();
    }
}

