/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentUtils {
    public static String format(List<Product> products) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder();
        Iterator<Product> iterator = products.iterator();
        while (iterator.hasNext()) {
            Product product = iterator.next();
            if (product.getName() == null || product.getName().length() == 0) {
                throw new IllegalArgumentException("Product name cannot be null.");
            }
            builder.append(product.getName());
            if (product.getVersion() != null) {
                builder.append("/").append(product.getVersion());
            }
            if (product.getComment() != null) {
                builder.append(" (").append(product.getComment()).append(")");
            }
            if (!iterator.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public static List<Product> parse(String userAgent) throws IllegalArgumentException {
        ArrayList<Product> result = new ArrayList<Product>();
        if (userAgent != null) {
            String token = null;
            String version = null;
            String comment = null;
            char[] tab = userAgent.trim().toCharArray();
            StringBuilder tokenBuilder = new StringBuilder();
            StringBuilder versionBuilder = null;
            StringBuilder commentBuilder = null;
            int index = 0;
            boolean insideToken = true;
            boolean insideVersion = false;
            boolean insideComment = false;
            for (index = 0; index < tab.length; ++index) {
                char c = tab[index];
                if (insideToken) {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ') {
                        tokenBuilder.append(c);
                        continue;
                    }
                    token = tokenBuilder.toString().trim();
                    insideToken = false;
                    if (c == '/') {
                        insideVersion = true;
                        versionBuilder = new StringBuilder();
                        continue;
                    }
                    if (c != '(') continue;
                    insideComment = true;
                    commentBuilder = new StringBuilder();
                    continue;
                }
                if (insideVersion) {
                    if (c != ' ') {
                        versionBuilder.append(c);
                        continue;
                    }
                    insideVersion = false;
                    version = versionBuilder.toString();
                    continue;
                }
                if (c == '(') {
                    insideComment = true;
                    commentBuilder = new StringBuilder();
                    continue;
                }
                if (insideComment) {
                    if (c == ')') {
                        insideComment = false;
                        comment = commentBuilder.toString();
                        result.add(new Product(token, version, comment));
                        insideToken = true;
                        tokenBuilder = new StringBuilder();
                        continue;
                    }
                    commentBuilder.append(c);
                    continue;
                }
                result.add(new Product(token, version, null));
                insideToken = true;
                tokenBuilder = new StringBuilder();
                tokenBuilder.append(c);
            }
            if (insideComment) {
                comment = commentBuilder.toString();
                result.add(new Product(token, version, comment));
            } else if (insideVersion) {
                version = versionBuilder.toString();
                result.add(new Product(token, version, null));
            } else if (insideToken && tokenBuilder.length() > 0) {
                token = tokenBuilder.toString();
                result.add(new Product(token, null, null));
            }
        }
        return result;
    }

    private UserAgentUtils() {
    }
}

