/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.util.Arrays;
import org.restlet.engine.io.ByteUtils;

public class Base64 {
    private static final char[] BASE64_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] DECODER_RING = new byte[128];

    private static final int byteAt(byte[] data, int block, int off) {
        return Base64.unsign(data[block * 3 + off]);
    }

    public static byte[] decode(char[] chars) {
        int newlineCount = 0;
        block6: for (char c : chars) {
            switch (c) {
                case '\n': 
                case '\r': {
                    ++newlineCount;
                    continue block6;
                }
            }
        }
        int len = chars.length - newlineCount;
        int numBytes = (len + 3) / 4 * 3;
        if (len > 1) {
            if (chars[chars.length - 2] == '=') {
                numBytes -= 2;
            } else if (chars[chars.length - 1] == '=') {
                --numBytes;
            }
        }
        byte[] result = new byte[numBytes];
        int newlineOffset = 0;
        block7: for (int i = 0; i < (len + 3) / 4; ++i) {
            int charOffset = newlineOffset + i * 4;
            char c1 = chars[charOffset++];
            char c2 = chars[charOffset++];
            char c3 = chars[charOffset++];
            char c4 = chars[charOffset++];
            if (!(Base64.validChar(c1) && Base64.validChar(c2) && Base64.validChar(c3) && Base64.validChar(c4))) {
                throw new IllegalArgumentException("Invalid Base64 character in block: '" + c1 + c2 + c3 + c4 + "'");
            }
            int x = DECODER_RING[c1] << 18 | DECODER_RING[c2] << 12 | (c3 == '=' ? 0 : DECODER_RING[c3] << 6) | (c4 == '=' ? 0 : DECODER_RING[c4]);
            int byteOffset = i * 3;
            result[byteOffset++] = (byte)(x >> 16);
            if (c3 != '=') {
                result[byteOffset++] = (byte)(x >> 8 & 0xFF);
                if (c4 != '=') {
                    result[byteOffset++] = (byte)(x & 0xFF);
                }
            }
            block8: while (chars.length > charOffset) {
                switch (chars[charOffset++]) {
                    case '\n': 
                    case '\r': {
                        ++newlineOffset;
                        continue block8;
                    }
                    default: {
                        continue block7;
                    }
                }
            }
        }
        return result;
    }

    public static byte[] decode(String encodedString) {
        return Base64.decode(encodedString.toCharArray());
    }

    public static String encode(byte[] bytes, boolean newlines) {
        return Base64.encode(bytes, 0, bytes.length, newlines);
    }

    public static String encode(byte[] bytes, int off, int len, boolean newlines) {
        char[] output = new char[(len + 2) / 3 * 4 + (newlines ? len / 43 : 0)];
        int pos = 0;
        for (int i = 0; i < (len + 2) / 3; ++i) {
            int pad = 0;
            if (len + 1 < (i + 1) * 3) {
                pad = 2;
            } else if (len < (i + 1) * 3) {
                pad = 1;
            }
            int x = Base64.byteAt(bytes, i, off) << 16 | (pad > 1 ? 0 : Base64.byteAt(bytes, i, off + 1) << 8) | (pad > 0 ? 0 : Base64.byteAt(bytes, i, off + 2));
            output[pos++] = BASE64_DIGITS[x >> 18];
            output[pos++] = BASE64_DIGITS[x >> 12 & 0x3F];
            output[pos++] = pad > 1 ? 61 : BASE64_DIGITS[x >> 6 & 0x3F];
            int n = output[pos++] = pad > 0 ? 61 : BASE64_DIGITS[x & 0x3F];
            if (!newlines || (i + 1) % 19 != 0) continue;
            output[pos++] = 10;
        }
        return new String(output, 0, pos);
    }

    public static String encode(char[] chars, boolean newlines) {
        return Base64.encode(ByteUtils.toByteArray(chars), newlines);
    }

    public static String encode(char[] chars, String charset, boolean newlines) {
        return Base64.encode(ByteUtils.toByteArray(chars, charset), newlines);
    }

    private static final int unsign(byte b) {
        return b < 0 ? b + 256 : b;
    }

    private static final boolean validChar(char c) {
        return c < '\u0080' && DECODER_RING[c] != -1;
    }

    static {
        Arrays.fill(DECODER_RING, (byte)-1);
        int i = 0;
        for (char c : BASE64_DIGITS) {
            Base64.DECODER_RING[c] = (byte)i++;
        }
        Base64.DECODER_RING[61] = 0;
    }
}

