/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.engine.io.NbChannelInputStream;
import org.restlet.engine.io.NbChannelOutputStream;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.ReaderInputStream;
import org.restlet.engine.io.WriterOutputStream;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public final class ByteUtils {
    public static long exhaust(InputStream input) throws IOException {
        long result = -1L;
        if (input != null) {
            byte[] buf = new byte[4096];
            int read = input.read(buf);
            long l = result = read == -1 ? -1L : 0L;
            while (read != -1) {
                result += (long)read;
                read = input.read(buf);
            }
        }
        return result;
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(Representation representation) throws IOException {
        Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a channel for a representation given its write(WritableByteChannel) method.");
        return null;
    }

    public static Reader getReader(InputStream stream, CharacterSet characterSet) throws UnsupportedEncodingException {
        if (characterSet != null) {
            return new InputStreamReader(stream, characterSet.getName());
        }
        return new InputStreamReader(stream);
    }

    public static Reader getReader(WriterRepresentation representation) throws IOException {
        Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a reader for a writer representation.");
        return null;
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        NbChannelInputStream result = null;
        if (readableChannel != null) {
            result = new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static InputStream getStream(Reader reader, CharacterSet characterSet) {
        ReaderInputStream result = null;
        try {
            result = new ReaderInputStream(reader, characterSet);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to create the reader input stream", e);
        }
        return result;
    }

    public static InputStream getStream(Representation representation) {
        Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to get an InputStream out of an OutputRepresentation.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getStream(WritableByteChannel writableChannel) {
        OutputStream result = null;
        if (writableChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                result = selectableChannel.isBlocking() ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
            }
        } else {
            result = new NbChannelOutputStream(writableChannel);
        }
        return result;
    }

    public static OutputStream getStream(Writer writer) {
        return new WriterOutputStream(writer);
    }

    public static byte[] toByteArray(char[] chars) {
        return ByteUtils.toByteArray(chars, Charset.defaultCharset().name());
    }

    public static byte[] toByteArray(char[] chars, String charsetName) {
        CharBuffer cb = CharBuffer.wrap(chars);
        ByteBuffer bb = Charset.forName(charsetName).encode(cb);
        byte[] r = new byte[bb.remaining()];
        bb.get(r);
        return r;
    }

    public static char[] toCharArray(byte[] bytes) {
        return ByteUtils.toCharArray(bytes, Charset.defaultCharset().name());
    }

    public static char[] toCharArray(byte[] bytes, String charsetName) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = Charset.forName(charsetName).decode(bb);
        char[] r = new char[cb.remaining()];
        cb.get(r);
        return r;
    }

    public static String toString(InputStream inputStream) {
        return ByteUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                result = characterSet != null ? ByteUtils.toString(new InputStreamReader(inputStream, characterSet.getName())) : ByteUtils.toString(new InputStreamReader(inputStream));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toString(Reader reader) {
        String result = null;
        if (reader != null) {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                char[] buffer = new char[8192];
                int charsRead = br.read(buffer);
                while (charsRead != -1) {
                    sb.append(buffer, 0, charsRead);
                    charsRead = br.read(buffer);
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void write(FileChannel fileChannel, WritableByteChannel writableChannel) throws IOException {
        long position = 0L;
        long count = fileChannel.size();
        long written = 0L;
        SelectableChannel selectableChannel = null;
        if (writableChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)writableChannel);
        }
        while (count > 0L) {
            NioUtils.waitForState(selectableChannel, 4);
            written = fileChannel.transferTo(position, count, writableChannel);
            position += written;
            count -= written;
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            randomAccessFile.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            ByteUtils.write((InputStream)new NbChannelInputStream(readableChannel), new NbChannelOutputStream(writableChannel));
        }
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int charsRead;
        char[] buffer = new char[2048];
        while ((charsRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, charsRead);
        }
        reader.close();
    }

    private ByteUtils() {
    }
}

