/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.Helper;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatorHelper
extends Helper {
    private volatile ChallengeScheme challengeScheme;
    private volatile boolean clientSide;
    private volatile boolean serverSide;

    public AuthenticatorHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        this.challengeScheme = challengeScheme;
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    @Deprecated
    public int authenticate(ChallengeResponse cr, Request request, Guard guard) {
        int result = 0;
        String identifier = cr.getIdentifier();
        char[] secret = cr.getSecret();
        if (identifier != null && secret != null) {
            result = guard.checkSecret(request, identifier, secret) ? 1 : -1;
        }
        return result;
    }

    @Deprecated
    public void challenge(Response response, boolean stale, Guard guard) {
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        response.getChallengeRequests().add(new ChallengeRequest(guard.getScheme(), guard.getRealm()));
    }

    public String format(ChallengeRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme().getTechnicalName());
        if (request.getRealm() != null) {
            sb.append(" realm=\"").append(request.getRealm()).append('\"');
        }
        this.formatParameters(sb, request.getParameters(), request);
        return sb.toString();
    }

    public String format(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        StringBuilder sb = new StringBuilder();
        sb.append(challenge.getScheme().getTechnicalName()).append(' ');
        if (challenge.getCredentials() != null) {
            sb.append(challenge.getCredentials());
        } else {
            this.formatCredentials(sb, challenge, request, httpHeaders);
        }
        return sb.toString();
    }

    public abstract void formatCredentials(StringBuilder var1, ChallengeResponse var2, Request var3, Series<Parameter> var4);

    public void formatParameters(StringBuilder sb, Series<Parameter> parameters, ChallengeRequest request) {
    }

    public ChallengeScheme getChallengeScheme() {
        return this.challengeScheme;
    }

    public Logger getLogger() {
        return Context.getCurrentLogger();
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void parseRequest(ChallengeRequest cr, String header) {
    }

    public void parseResponse(ChallengeResponse cr, Request request) {
    }

    public void setChallengeScheme(ChallengeScheme challengeScheme) {
        this.challengeScheme = challengeScheme;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }
}

