/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DigestUtils;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpDigestHelper
extends AuthenticatorHelper {
    private static String getHashedSecret(String identifier, Guard guard) {
        char[] result = guard.getSecretResolver().resolve(identifier);
        if (result != null) {
            return DigestUtils.toMd5(identifier + ":" + guard.getRealm() + ":" + new String(result));
        }
        return null;
    }

    private static boolean isNonceValid(String nonce, String secretKey, long lifespanMS) throws Exception {
        try {
            String decodedNonce = new String(Base64.decode(nonce));
            long nonceTimeMS = Long.parseLong(decodedNonce.substring(0, decodedNonce.indexOf(58)));
            if (decodedNonce.equals(nonceTimeMS + ":" + DigestUtils.toMd5(nonceTimeMS + ":" + secretKey))) {
                return lifespanMS > System.currentTimeMillis() - nonceTimeMS;
            }
        }
        catch (Exception e) {
            throw new Exception("error parsing nonce: " + e);
        }
        throw new Exception("nonce does not match secretKey");
    }

    public HttpDigestHelper() {
        super(ChallengeScheme.HTTP_DIGEST, true, true);
    }

    @Override
    public int authenticate(ChallengeResponse cr, Request request, Guard guard) {
        Series<Parameter> credentials = cr.getParameters();
        String username = credentials.getFirstValue("username");
        String nonce = credentials.getFirstValue("nonce");
        String response = credentials.getFirstValue("response");
        String uri = credentials.getFirstValue("uri");
        String qop = credentials.getFirstValue("qop");
        String nc = credentials.getFirstValue("nc");
        String cnonce = credentials.getFirstValue("cnonce");
        try {
            if (!HttpDigestHelper.isNonceValid(nonce, guard.getServerKey(), guard.getNonceLifespan())) {
                return 2;
            }
        }
        catch (Exception ce) {
            return -1;
        }
        if (!AuthenticatorUtils.anyNull(username, nonce, response, uri)) {
            String a1;
            Reference resourceRef = request.getResourceRef();
            String requestUri = resourceRef.getPath();
            if (resourceRef.getQuery() != null && uri.indexOf(63) > -1) {
                requestUri = requestUri + "?" + resourceRef.getQuery();
            }
            if (uri.equals(requestUri) && (a1 = HttpDigestHelper.getHashedSecret(username, guard)) != null) {
                String a2 = DigestUtils.toMd5(request.getMethod() + ":" + requestUri);
                StringBuffer expectedResponse = new StringBuffer(a1).append(':').append(nonce);
                if (!AuthenticatorUtils.anyNull(qop, cnonce, nc)) {
                    expectedResponse.append(':').append(nc).append(':').append(cnonce).append(':').append(qop);
                }
                expectedResponse.append(':').append(a2);
                if (response.equals(DigestUtils.toMd5(expectedResponse.toString()))) {
                    return 1;
                }
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void challenge(Response response, boolean stale, Guard guard) {
        super.challenge(response, stale, guard);
        if (stale) {
            response.getAttributes().put("stale", "true");
        }
        ChallengeRequest mainChallengeRequest = null;
        for (ChallengeRequest challengeRequest : response.getChallengeRequests()) {
            if (!challengeRequest.getScheme().equals(guard.getScheme())) continue;
            mainChallengeRequest = challengeRequest;
            break;
        }
        Series<Parameter> parameters = mainChallengeRequest.getParameters();
        StringBuffer domain = new StringBuffer();
        for (String baseUri : guard.getDomainUris()) {
            domain.append(baseUri).append(' ');
        }
        if (domain.length() > 0) {
            domain.delete(domain.length() - 1, domain.length());
            parameters.add("domain", domain.toString());
        }
        parameters.add("nonce", DigestUtils.makeNonce(guard.getServerKey()));
        if (response.getAttributes().containsKey("stale")) {
            parameters.add("stale", "true");
        }
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        Series<Parameter> params = challenge.getParameters();
        for (Parameter param : params) {
            sb.append(param.getName()).append('=');
            if (param.getName().equals("qop") || param.getName().equals("algorithm") || param.getName().equals("nc")) {
                sb.append(param.getValue()).append(",");
                continue;
            }
            sb.append('\"').append(param.getValue()).append('\"').append(",");
        }
        if (!params.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    public void formatParameters(StringBuilder sb, Series<Parameter> parameters, ChallengeRequest request) {
        sb.append(", domain=\"").append(parameters.getFirstValue("domain")).append('\"');
        sb.append(", qop=\"auth\"");
        sb.append(", algorithm=MD5");
        sb.append(", nonce=\"").append(parameters.getFirstValue("nonce")).append('\"');
        if (parameters.getFirst("stale") != null) {
            sb.append(", stale=\"true\"");
        }
    }

    @Override
    public void parseResponse(ChallengeResponse cr, Request request) {
        AuthenticatorUtils.parseParameters(cr.getCredentials(), cr.getParameters());
    }
}

