/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.util.DigestUtils;
import org.restlet.security.LocalVerifier;
import org.restlet.security.SecretVerifier;

public class DigestVerifier
extends SecretVerifier {
    private String inputAlgorithm;
    private String outputAlgorithm;
    private SecretVerifier wrappedVerifier;

    public DigestVerifier(String inputAlgorithm, String outputAlgorithm, SecretVerifier wrappedVerifier) {
        this.inputAlgorithm = inputAlgorithm;
        this.outputAlgorithm = outputAlgorithm;
        this.wrappedVerifier = wrappedVerifier;
    }

    protected char[] digest(char[] secret, String algorithm) {
        return DigestUtils.digest(secret, algorithm);
    }

    public String getInputAlgorithm() {
        return this.inputAlgorithm;
    }

    public String getOutputAlgorithm() {
        return this.outputAlgorithm;
    }

    public SecretVerifier getWrappedVerifier() {
        return this.wrappedVerifier;
    }

    public void setInputAlgorithm(String inputAlgorithm) {
        this.inputAlgorithm = inputAlgorithm;
    }

    public void setOutputAlgorithm(String outputAlgorithm) {
        this.outputAlgorithm = outputAlgorithm;
    }

    public void setWrappedVerifier(SecretVerifier wrappedVerifier) {
        this.wrappedVerifier = wrappedVerifier;
    }

    public final boolean verify(String identifier, char[] inputSecret) {
        boolean result = false;
        char[] inputSecretDigest = inputSecret;
        if (this.getInputAlgorithm() == null) {
            if (this.getOutputAlgorithm() != null) {
                inputSecretDigest = this.digest(inputSecret, this.getOutputAlgorithm());
            }
            result = this.getWrappedVerifier().verify(identifier, inputSecretDigest);
        } else if (this.getOutputAlgorithm() == null) {
            if (this.getWrappedVerifier() instanceof LocalVerifier) {
                LocalVerifier localVerifier = (LocalVerifier)this.getWrappedVerifier();
                result = DigestVerifier.compare(inputSecretDigest, this.digest(localVerifier.getSecret(identifier), this.getInputAlgorithm()));
            } else {
                Context.getCurrentLogger().log(Level.WARNING, "The wrapped verifier must be a LocalVerifier to allow digesting of output secrets.");
            }
        } else if (this.getInputAlgorithm().equals(this.getOutputAlgorithm())) {
            result = this.getWrappedVerifier().verify(identifier, inputSecretDigest);
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The input and output algorithms can't be different.");
        }
        return result;
    }
}

