/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.engine.util.FormUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormReader {
    private volatile CharacterSet characterSet;
    private volatile boolean decoding;
    private volatile InputStream stream;
    private volatile char separator;

    public FormReader(Representation representation) throws IOException {
        this.decoding = true;
        this.stream = representation.getStream();
        this.separator = (char)38;
        this.characterSet = representation.getCharacterSet() != null ? representation.getCharacterSet() : CharacterSet.UTF_8;
    }

    public FormReader(String parametersString, char separator) {
        this.decoding = false;
        this.stream = new ByteArrayInputStream(parametersString.getBytes());
        this.characterSet = null;
        this.separator = separator;
    }

    public FormReader(String parametersString, CharacterSet characterSet, char separator) {
        this.decoding = true;
        this.stream = new ByteArrayInputStream(parametersString.getBytes());
        this.characterSet = characterSet;
        this.separator = separator;
    }

    public void addParameters(Form form) {
        boolean readNext = true;
        Parameter param = null;
        if (this.stream != null) {
            try {
                while (readNext) {
                    param = this.readNextParameter();
                    if (param != null) {
                        form.add(param);
                        continue;
                    }
                    readNext = false;
                }
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse a form parameter. Skipping the remaining parameters.", ioe);
            }
            try {
                this.stream.close();
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to close the form input stream", ioe);
            }
        }
    }

    public Form read() throws IOException {
        Form result = new Form();
        Parameter param = this.readNextParameter();
        while (param != null) {
            result.add(param);
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public Parameter readFirstParameter(String name) throws IOException {
        Parameter param = this.readNextParameter();
        Parameter result = null;
        while (param != null && result == null) {
            if (param.getName().equals(name)) {
                result = param;
            }
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public Parameter readNextParameter() throws IOException {
        Parameter result = null;
        try {
            boolean readingName = true;
            boolean readingValue = false;
            StringBuilder nameBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            char nextChar = '\u0000';
            while (result == null && nextChar != '\uffffffff') {
                nextChar = this.stream.read();
                if (readingName) {
                    if (nextChar == '=') {
                        if (nameBuffer.length() > 0) {
                            readingName = false;
                            readingValue = true;
                            continue;
                        }
                        throw new IOException("Empty parameter name detected. Please check your form data");
                    }
                    if (nextChar == this.separator || nextChar == '\uffffffff') {
                        if (nameBuffer.length() > 0) {
                            result = FormUtils.create(nameBuffer, null, this.decoding, this.characterSet);
                            continue;
                        }
                        if (nextChar == '\uffffffff') continue;
                        Context.getCurrentLogger().fine("Empty parameter name detected. Please check your form data");
                        continue;
                    }
                    nameBuffer.append(nextChar);
                    continue;
                }
                if (!readingValue) continue;
                if (nextChar == this.separator || nextChar == '\uffffffff') {
                    if (valueBuffer.length() > 0) {
                        result = FormUtils.create(nameBuffer, valueBuffer, this.decoding, this.characterSet);
                        continue;
                    }
                    result = FormUtils.create(nameBuffer, null, this.decoding, this.characterSet);
                    continue;
                }
                valueBuffer.append(nextChar);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("Unsupported encoding. Please contact the administrator");
        }
        return result;
    }

    public Object readParameter(String name) throws IOException {
        Parameter param = this.readNextParameter();
        Object result = null;
        while (param != null) {
            if (param.getName().equals(name)) {
                if (result != null) {
                    ArrayList<Object> values = null;
                    if (result instanceof List) {
                        values = (ArrayList<Object>)result;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(result);
                        result = values;
                    }
                    if (param.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(param.getValue());
                    }
                } else {
                    result = param.getValue() == null ? Series.EMPTY_VALUE : param.getValue();
                }
            }
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public void readParameters(Map<String, Object> parameters) throws IOException {
        Parameter param = this.readNextParameter();
        Object currentValue = null;
        while (param != null) {
            if (parameters.containsKey(param.getName())) {
                currentValue = parameters.get(param.getName());
                if (currentValue != null) {
                    ArrayList<Object> values = null;
                    if (currentValue instanceof List) {
                        values = (ArrayList<Object>)currentValue;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(currentValue);
                        parameters.put(param.getName(), values);
                    }
                    if (param.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(param.getValue());
                    }
                } else if (param.getValue() == null) {
                    parameters.put(param.getName(), Series.EMPTY_VALUE);
                } else {
                    parameters.put(param.getName(), param.getValue());
                }
            }
            param = this.readNextParameter();
        }
        this.stream.close();
    }
}

