/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.local.Entity;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

public class FileEntity
extends Entity {
    private final File file;

    public FileEntity(File file, MetadataService metadataService) {
        super(metadataService);
        this.file = file;
    }

    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    @Override
    public List<Entity> getChildren() {
        ArrayList<FileEntity> result = null;
        if (this.isDirectory()) {
            result = new ArrayList<FileEntity>();
            try {
                for (File f : this.getFile().listFiles()) {
                    result.add(new FileEntity(f, this.getMetadataService()));
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    public Entity getParent() {
        File parentFile = this.getFile().getParentFile();
        return parentFile == null ? null : new FileEntity(parentFile, this.getMetadataService());
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        return new FileRepresentation(this.getFile(), defaultMediaType, timeToLive);
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.getFile().isDirectory();
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    @Override
    public boolean isNormal() {
        try {
            return this.getFile().isFile();
        }
        catch (AccessControlException ace) {
            return false;
        }
    }
}

