/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch04.sec2.sub2;

import java.io.IOException;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MailServerResource
extends ServerResource {
    protected Representation get() throws ResourceException {
        DomRepresentation result;
        try {
            result = new DomRepresentation();
            result.setIndenting(true);
            Document doc = result.getDocument();
            Element mailElt = doc.createElement("mail");
            doc.appendChild(mailElt);
            Element statusElt = doc.createElement("status");
            statusElt.setTextContent("received");
            mailElt.appendChild(statusElt);
            Element subjectElt = doc.createElement("subject");
            subjectElt.setTextContent("Message to self");
            mailElt.appendChild(subjectElt);
            Element contentElt = doc.createElement("content");
            contentElt.setTextContent("Doh!");
            mailElt.appendChild(contentElt);
            Element accountRefElt = doc.createElement("accountRef");
            accountRefElt.setTextContent(new Reference(this.getReference(), "..").getTargetRef().toString());
            mailElt.appendChild(accountRefElt);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        DomRepresentation mailRep = new DomRepresentation(representation);
        try {
            Document doc = mailRep.getDocument();
            Element mailElt = doc.getDocumentElement();
            Element statusElt = (Element)mailElt.getElementsByTagName("status").item(0);
            Element subjectElt = (Element)mailElt.getElementsByTagName("subject").item(0);
            Element contentElt = (Element)mailElt.getElementsByTagName("content").item(0);
            Element accountRefElt = (Element)mailElt.getElementsByTagName("accountRef").item(0);
            System.out.println("Status: " + statusElt.getTextContent());
            System.out.println("Subject: " + subjectElt.getTextContent());
            System.out.println("Content: " + contentElt.getTextContent());
            System.out.println("Account URI: " + accountRefElt.getTextContent());
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return null;
    }
}

