/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec2;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.Authenticator;
import org.restlet.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertificateAuthenticator
extends Authenticator {
    public ClientCertificateAuthenticator(Context context) {
        super(context);
    }

    protected List<Principal> getPrincipals(List<X509Certificate> certificateChain) {
        if (certificateChain != null && certificateChain.size() > 0) {
            ArrayList<Principal> principals = new ArrayList<Principal>();
            X509Certificate userCert = certificateChain.get(0);
            principals.add(userCert.getSubjectX500Principal());
            return principals;
        }
        return null;
    }

    protected User getUser(Principal principal) {
        if (principal != null) {
            return new User(principal.getName());
        }
        return null;
    }

    protected boolean authenticate(Request request, Response response) {
        List certchain = (List)request.getAttributes().get("org.restlet.https.clientCertificates");
        List<Principal> principals = this.getPrincipals(certchain);
        if (principals != null && principals.size() > 0) {
            request.getClientInfo().getPrincipals().addAll(principals);
            User user = this.getUser(principals.get(0));
            if (user != null) {
                request.getClientInfo().setUser(user);
            }
            return true;
        }
        return false;
    }
}

