/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch06.sec2.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.MediaType;
import org.restlet.example.book.restlet.ch02.sect5.sub5.common.AccountsResource;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountsServerResource
extends WadlServerResource
implements AccountsResource {
    private static final List<String> accounts = new CopyOnWriteArrayList<String>();

    protected void describe(ApplicationInfo applicationInfo) {
        super.describe(applicationInfo);
        RepresentationInfo rep = new RepresentationInfo(MediaType.TEXT_PLAIN);
        rep.setIdentifier("account");
        applicationInfo.getRepresentations().add(rep);
        DocumentationInfo doc = new DocumentationInfo();
        doc.setTitle("Account");
        doc.setTextContent("Simple string containing the account ID");
        rep.getDocumentations().add(doc);
    }

    protected RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Variant variant) {
        RepresentationInfo result = super.describe(methodInfo, representationClass, variant);
        result.setReference("account");
        return result;
    }

    protected void doInit() throws ResourceException {
        this.setName("Mail accounts resource");
        this.setDescription("The resource containing the list of mail accounts");
    }

    public static List<String> getAccounts() {
        return accounts;
    }

    @Override
    public String represent() {
        StringBuilder result = new StringBuilder();
        for (String account : AccountsServerResource.getAccounts()) {
            result.append(account == null ? "" : account).append('\n');
        }
        return result.toString();
    }

    @Override
    public String add(String account) {
        AccountsServerResource.getAccounts().add(account);
        return Integer.toString(AccountsServerResource.getAccounts().indexOf(account));
    }
}

