/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch07.sec5.website;

import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.example.book.restlet.ch07.sec5.website.AccountServerResource;
import org.restlet.example.book.restlet.ch07.sec5.website.AccountsServerResource;
import org.restlet.example.book.restlet.ch07.sec5.website.CookieAuthenticator;
import org.restlet.example.book.restlet.ch07.sec5.website.FeedServerResource;
import org.restlet.example.book.restlet.ch07.sec5.website.MailServerResource;
import org.restlet.example.book.restlet.ch07.sec5.website.MailStatusService;
import org.restlet.example.book.restlet.ch07.sec5.website.RootServerResource;
import org.restlet.resource.Directory;
import org.restlet.routing.Extractor;
import org.restlet.routing.Redirector;
import org.restlet.routing.Router;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;

public class MailSiteApplication
extends Application {
    public MailSiteApplication() {
        this.setName("RESTful Mail Site application");
        this.setDescription("Example Site for 'Restlet in Action' book");
        this.setOwner("Restlet S.A.S.");
        this.setAuthor("The Restlet Team");
        this.setStatusService(new MailStatusService());
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/", RootServerResource.class);
        router.attach("/accounts/", AccountsServerResource.class);
        router.attach("/accounts/{accountId}", AccountServerResource.class);
        router.attach("/accounts/{accountId}/feeds/{feedId}", FeedServerResource.class);
        router.attach("/accounts/{accountId}/mails/{mailId}", MailServerResource.class);
        String rootUri = "file:///" + System.getProperty("java.io.tmpdir");
        Directory directory = new Directory(this.getContext(), rootUri);
        directory.setListingAllowed(true);
        router.attach("/static", (Restlet)directory);
        String target = "http://www.google.com/search?q=site:mysite.org+{keywords}";
        Redirector redirector = new Redirector(this.getContext(), target, 4);
        Extractor extractor = new Extractor(this.getContext(), (Restlet)redirector);
        extractor.extractFromQuery("keywords", "kwd", true);
        router.attach("/search", (Restlet)extractor);
        MapVerifier verifier = new MapVerifier();
        verifier.getLocalSecrets().put("scott", "tiger".toCharArray());
        CookieAuthenticator authenticator = new CookieAuthenticator(this.getContext(), "Cookie Test");
        authenticator.setVerifier((Verifier)verifier);
        authenticator.setNext((Restlet)router);
        return authenticator;
    }
}

