/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.ext.freemarker.internal.ResolverHashModel;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.util.Resolver;

public class TemplateRepresentation
extends WriterRepresentation {
    private volatile Object dataModel;
    private volatile Template template;

    public static Template getTemplate(Configuration config, Representation templateRepresentation) {
        try {
            if (templateRepresentation.getCharacterSet() != null) {
                return new Template("template", templateRepresentation.getReader(), config, templateRepresentation.getCharacterSet().getName());
            }
            return new Template("template", templateRepresentation.getReader(), config, CharacterSet.UTF_8.getName());
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Unable to get the template from the representation " + templateRepresentation.getLocationRef() + ". Error message: " + e.getMessage());
            return null;
        }
    }

    public static Template getTemplate(Configuration config, String templateName) {
        try {
            return config.getTemplate(templateName);
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Unable to get the template " + templateName + ". Error message: " + e.getMessage());
            return null;
        }
    }

    public TemplateRepresentation(Representation templateRepresentation, Configuration config, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(config, templateRepresentation), mediaType);
    }

    public TemplateRepresentation(Representation templateRepresentation, Configuration config, Object dataModel, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(config, templateRepresentation), dataModel, mediaType);
    }

    public TemplateRepresentation(Representation templateRepresentation, MediaType mediaType) {
        this(templateRepresentation, new Configuration(), mediaType);
    }

    public TemplateRepresentation(Representation templateRepresentation, Object dataModel, MediaType mediaType) {
        this(templateRepresentation, new Configuration(), dataModel, mediaType);
    }

    public TemplateRepresentation(String templateName, Configuration config, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(config, templateName), mediaType);
    }

    public TemplateRepresentation(String templateName, Configuration config, Object dataModel, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(config, templateName), dataModel, mediaType);
    }

    public TemplateRepresentation(Template template, MediaType mediaType) {
        super(mediaType);
        this.template = template;
    }

    public TemplateRepresentation(Template template, Object dataModel, MediaType mediaType) {
        super(mediaType);
        this.template = template;
        this.dataModel = dataModel;
    }

    public Object getDataModel() {
        return this.dataModel;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Object setDataModel(Object dataModel) {
        this.dataModel = dataModel;
        return dataModel;
    }

    public Object setDataModel(Request request, Response response) {
        this.dataModel = new ResolverHashModel((Resolver<? extends Object>)Resolver.createResolver((Request)request, (Response)response));
        return this.dataModel;
    }

    public Object setDataModel(Resolver<Object> resolver) {
        this.dataModel = new ResolverHashModel(resolver);
        return this.dataModel;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void write(Writer writer) throws IOException {
        if (this.template != null) {
            try {
                this.template.process(this.getDataModel(), writer);
            }
            catch (TemplateException te) {
                throw new IOException("Template processing error " + te.getMessage());
            }
        } else {
            Context.getCurrentLogger().warning("Unable to write the template representation. No template found.");
        }
    }
}

