/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gwt;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.Serializable;
import org.restlet.data.MediaType;
import org.restlet.engine.Engine;
import org.restlet.ext.gwt.SimpleSerializationPolicy;
import org.restlet.ext.gwt.SimpleSerializationPolicyProvider;
import org.restlet.representation.StringRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRepresentation<T extends Serializable>
extends StringRepresentation {
    private T object;
    private SerializationPolicy serializationPolicy;
    private SerializationPolicyProvider serializationPolicyProvider;
    private Class<T> targetClass;

    public ObjectRepresentation(String serializedObject, Class<T> targetClass) {
        super((CharSequence)serializedObject, MediaType.APPLICATION_JAVA_OBJECT_GWT);
        this.targetClass = targetClass;
        this.object = null;
        this.serializationPolicy = SimpleSerializationPolicy.getInstance();
        this.serializationPolicyProvider = new SimpleSerializationPolicyProvider();
    }

    public ObjectRepresentation(T object) {
        super(null, MediaType.APPLICATION_JAVA_OBJECT_GWT);
        this.object = object;
        this.targetClass = object.getClass();
        this.serializationPolicy = SimpleSerializationPolicy.getInstance();
        this.serializationPolicyProvider = new SimpleSerializationPolicyProvider();
    }

    public T getObject() {
        if (this.object == null && this.getText() != null) {
            try {
                ServerSerializationStreamReader objectReader = new ServerSerializationStreamReader(Engine.getClassLoader(), (SerializationPolicyProvider)new SimpleSerializationPolicyProvider());
                String encodedString = this.getText();
                if (encodedString.indexOf(124) == -1) {
                    encodedString = "5|1|0|0|0|" + this.getText() + '|';
                }
                objectReader.prepareToRead(encodedString);
                this.object = (Serializable)objectReader.deserializeValue(this.targetClass);
            }
            catch (Exception e) {
                this.object = null;
                e.printStackTrace();
            }
        }
        return this.object;
    }

    public SerializationPolicy getSerializationPolicy() {
        return this.serializationPolicy;
    }

    public SerializationPolicyProvider getSerializationPolicyProvider() {
        return this.serializationPolicyProvider;
    }

    public String getText() {
        if (this.object != null && super.getText() == null) {
            try {
                ServerSerializationStreamWriter objectWriter = new ServerSerializationStreamWriter(this.getSerializationPolicy());
                objectWriter.serializeValue(this.object, this.targetClass);
                this.setText(objectWriter.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getText();
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setSerializationPolicy(SerializationPolicy serializationPolicy) {
        this.serializationPolicy = serializationPolicy;
    }

    public void setSerializationPolicyProvider(SerializationPolicyProvider serializationPolicyProvider) {
        this.serializationPolicyProvider = serializationPolicyProvider;
    }
}

