/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import java.io.IOException;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonRepresentation<T>
extends WriterRepresentation {
    private T object;
    private Class<T> objectClass;
    private Representation jsonRepresentation;
    private ObjectMapper objectMapper;

    public JacksonRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.objectClass = object == null ? null : object.getClass();
        this.jsonRepresentation = null;
        this.objectMapper = null;
    }

    public JacksonRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.object = null;
        this.objectClass = objectClass;
        this.jsonRepresentation = representation;
        this.objectMapper = null;
    }

    public JacksonRepresentation(T object) {
        this(MediaType.APPLICATION_JSON, object);
    }

    protected ObjectMapper createObjectMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper(jsonFactory);
    }

    public T getObject() throws IOException {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.jsonRepresentation != null) {
            result = this.getObjectMapper().readValue(this.jsonRepresentation.getStream(), this.objectClass);
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = this.createObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void write(Writer writer) throws IOException {
        if (this.jsonRepresentation != null) {
            this.jsonRepresentation.write(writer);
        } else if (this.object != null) {
            this.getObjectMapper().writeValue(writer, this.object);
        }
    }
}

