/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingConstructorException;
import org.restlet.util.NamedValue;

public class WrapperUtil {
    private static final String JAX_RS_PACKAGE_PREFIX = "javax.ws.rs";

    static boolean checkForJaxRsAnnotations(java.lang.reflect.Method javaMethod) {
        for (Annotation annotation : javaMethod.getAnnotations()) {
            Class<? extends Annotation> annoType = annotation.annotationType();
            if (annoType.getName().startsWith(JAX_RS_PACKAGE_PREFIX)) {
                return true;
            }
            if (!annoType.isAnnotationPresent(HttpMethod.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkParamAnnotations(Constructor<?> constr) {
        Annotation[][] paramAnnotationss = constr.getParameterAnnotations();
        Class<?>[] parameterTypes = constr.getParameterTypes();
        for (int i = 0; i < paramAnnotationss.length; ++i) {
            Annotation[] parameterAnnotations = paramAnnotationss[i];
            Class<?> parameterType = parameterTypes[i];
            boolean ok = WrapperUtil.checkParameterAnnotation(parameterAnnotations, parameterType);
            if (ok) continue;
            return false;
        }
        return true;
    }

    private static boolean checkParameterAnnotation(Annotation[] parameterAnnotations, Class<?> parameterType) {
        if (parameterAnnotations.length == 0) {
            return false;
        }
        for (Annotation annotation : parameterAnnotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.equals(HeaderParam.class) || annotationType.equals(PathParam.class)) continue;
            if (annotationType.equals(Context.class)) {
                if (parameterType.equals(UriInfo.class) || parameterType.equals(Request.class) || parameterType.equals(HttpHeaders.class) || parameterType.equals(SecurityContext.class)) continue;
                return false;
            }
            if (annotationType.equals(MatrixParam.class) || annotationType.equals(QueryParam.class)) continue;
            return false;
        }
        return true;
    }

    public static List<MediaType> convertToMediaTypes(String[] mimes) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(mimes.length);
        for (String mime : mimes) {
            if (mime == null) {
                mediaTypes.add(MediaType.ALL);
                continue;
            }
            mediaTypes.add(MediaType.valueOf((String)mime));
        }
        return Collections.unmodifiableList(mediaTypes);
    }

    public static Object createInstance(Constructor<?> constructor, Object ... args) throws InvocationTargetException, InstantiateException {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new InstantiateException("Could not instantiate " + constructor.getDeclaringClass(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InstantiateException("Could not instantiate " + constructor.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InstantiateException("Could not instantiate " + constructor.getDeclaringClass(), (Throwable)e);
        }
    }

    public static Constructor<?> findJaxRsConstructor(Class<?> jaxRsClass, String rrcOrProvider) throws MissingConstructorException {
        Constructor<?> constructor = null;
        int constructorParamNo = Integer.MIN_VALUE;
        for (Constructor<?> constr : jaxRsClass.getConstructors()) {
            int constrParamNo;
            if (!Modifier.isPublic(constr.getModifiers()) || (constrParamNo = constr.getParameterTypes().length) <= constructorParamNo || !WrapperUtil.checkParamAnnotations(constr)) continue;
            constructor = constr;
            constructorParamNo = constrParamNo;
        }
        if (constructor != null) {
            return constructor;
        }
        throw new MissingConstructorException(jaxRsClass, rrcOrProvider);
    }

    static Method getHttpMethod(java.lang.reflect.Method javaMethod) {
        for (Annotation annotation : javaMethod.getAnnotations()) {
            Class<? extends Annotation> annoType = annotation.annotationType();
            HttpMethod httpMethodAnnot = annoType.getAnnotation(HttpMethod.class);
            if (httpMethodAnnot == null) continue;
            String httpMethodName = httpMethodAnnot.value();
            return Method.valueOf((String)httpMethodName);
        }
        return null;
    }

    public static String getValue(NamedValue<String> namedValue) {
        if (namedValue == null) {
            return null;
        }
        String paramValue = (String)namedValue.getValue();
        if (paramValue == null) {
            return "";
        }
        return paramValue;
    }

    public static boolean isBeanSetter(java.lang.reflect.Method method, Class<? extends Annotation> annotationClass) throws SecurityException {
        return method.isAnnotationPresent(annotationClass) && method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    static boolean isVolatile(java.lang.reflect.Method javaMethod) {
        return Modifier.isVolatile(javaMethod.getModifiers());
    }
}

