/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.lucene;

import java.io.IOException;
import java.util.Date;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.representation.Representation;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaRepresentation
extends SaxRepresentation {
    private Metadata metadata;
    private Representation representation;
    private TikaConfig tikaConfig;
    private Parser tikaParser;

    public TikaRepresentation(Representation representation) {
        this(representation, null);
    }

    public TikaRepresentation(Representation representation, TikaConfig tikaConfig) {
        this(representation, tikaConfig, null);
    }

    public TikaRepresentation(Representation representation, TikaConfig tikaConfig, Parser tikaParser) {
        super(representation == null ? null : representation.getMediaType());
        this.tikaConfig = tikaConfig;
        this.representation = representation;
        this.metadata = new Metadata();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public TikaConfig getTikaConfig() {
        return this.tikaConfig;
    }

    public Parser getTikaParser() {
        return this.tikaParser;
    }

    public void parse(ContentHandler contentHandler) throws IOException {
        if (this.representation != null) {
            try {
                String name;
                if (this.representation.getDisposition() != null && (name = this.representation.getDisposition().getFilename()) != null) {
                    this.getMetadata().set("resourceName", name);
                    this.getMetadata().set("Content-Disposition", name);
                }
                this.getMetadata().set("Content-Type", this.representation.getMediaType().toString());
                if (this.representation.getSize() != -1L) {
                    this.getMetadata().set("Content-Length", Long.toString(this.representation.getSize()));
                }
                if (this.representation.getModificationDate() != null) {
                    this.getMetadata().set("Last-Modified", DateUtils.format((Date)this.representation.getModificationDate()));
                }
                Parser parser = this.getTikaParser() != null ? this.getTikaParser() : (this.getTikaConfig() != null ? new AutoDetectParser(this.getTikaConfig()) : new AutoDetectParser());
                parser.parse(this.representation.getStream(), contentHandler, this.getMetadata(), new ParseContext());
            }
            catch (SAXException e) {
                throw new IOException("SAX exception: " + e.getLocalizedMessage());
            }
            catch (TikaException e) {
                throw new IOException("Tika exception: " + e.getLocalizedMessage());
            }
        } else {
            throw new IOException("No wrapped representation to parse.");
        }
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public void setTikaParser(Parser tikaParser) {
        this.tikaParser = tikaParser;
    }
}

