/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.memory.ExpireToken;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.restlet.security.SecretVerifier;
import org.restlet.security.User;

public class AccessTokenServerResource
extends OAuthServerResource {
    @Post(value="form:json")
    public Representation requestToken(Representation input) throws OAuthException {
        this.getLogger().fine("Grant request");
        Form params = new Form(input);
        User clientCredential = this.getRequest().getClientInfo().getUser();
        if (clientCredential == null) {
            this.getLogger().warning("Client ID is missing! No Authenticator?");
            throw new OAuthException(OAuthError.server_error, "No Client Credential.", null);
        }
        Client client = this.clients.findById(clientCredential.getIdentifier());
        this.getLogger().fine("Requested by authenticated client " + client.getClientId());
        GrantType grantType = this.getGrantType(params);
        switch (grantType) {
            case authorization_code: {
                this.getLogger().info("Authorization Code Grant");
                return this.doAuthCodeFlow(client, params);
            }
            case password: {
                this.getLogger().info("Resource Owner Password Credentials Grant");
                return this.doPasswordFlow(client, params);
            }
            case refresh_token: {
                this.getLogger().info("Refreshing an Access Token");
                return this.doRefreshFlow(client, params);
            }
        }
        this.getLogger().warning("Unsupported flow: " + (Object)((Object)grantType));
        throw new OAuthException(OAuthError.unsupported_grant_type, "Flow not supported", null);
    }

    protected void doCatch(Throwable t) {
        OAuthException oex = OAuthException.toOAuthException(t);
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        this.getResponse().setEntity(AccessTokenServerResource.responseErrorRepresentation(oex));
        AccessTokenServerResource.addCacheDirective(this.getResponse(), CacheDirective.noStore());
    }

    protected GrantType getGrantType(Form params) throws OAuthException {
        String typeString = params.getFirstValue("grant_type");
        this.getLogger().info("Type: " + typeString);
        try {
            GrantType type = Enum.valueOf(GrantType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            return type;
        }
        catch (IllegalArgumentException iae) {
            throw new OAuthException(OAuthError.unsupported_grant_type, "Unsupported flow", null);
        }
        catch (NullPointerException npe) {
            throw new OAuthException(OAuthError.invalid_request, "No grant_type parameter found.", null);
        }
    }

    protected String getCode(Form params) throws OAuthException {
        String code = params.getFirstValue("code");
        if (code == null || code.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter code is missing", null);
        }
        return code;
    }

    protected String getUsername(Form params) throws OAuthException {
        String username = params.getFirstValue("username");
        if (username == null || username.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter username is missing", null);
        }
        return username;
    }

    protected String getPassword(Form params) throws OAuthException {
        String password = params.getFirstValue("password");
        if (password == null || password.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter password is missing", null);
        }
        return password;
    }

    protected String getRefreshToken(Form params) throws OAuthException {
        String token = params.getFirstValue("refresh_token");
        if (token == null || token.isEmpty()) {
            throw new OAuthException(OAuthError.invalid_request, "Mandatory parameter refresh_token is missing", null);
        }
        return token;
    }

    protected Representation responseTokenRepresentation(Token token, String scopes) throws ResourceException {
        JSONObject response = new JSONObject();
        try {
            response.put("token_type", (Object)"Bearer");
            response.put("access_token", (Object)token.getToken());
            long expiresIn = token.getExpirePeriod();
            if (expiresIn != 0L) {
                response.put("expires_in", expiresIn);
                response.put("refresh_token", (Object)token.getRefreshToken());
            }
            if (scopes != null && !scopes.isEmpty()) {
                response.put("scope", (Object)scopes);
            }
        }
        catch (JSONException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Failed to generate JSON", (Throwable)e);
        }
        AccessTokenServerResource.addCacheDirective(this.getResponse(), CacheDirective.noStore());
        return new JsonRepresentation(response);
    }

    private Representation doAuthCodeFlow(Client client, Form params) throws IllegalArgumentException, OAuthException {
        String code = this.getCode(params);
        Token token = this.generator.exchangeForToken(code, this.tokenTimeSec);
        String scopes = Scopes.toScope(token.getUser().getGrantedRoles());
        return this.responseTokenRepresentation(token, scopes);
    }

    private Representation doPasswordFlow(Client client, Form params) throws OAuthException {
        AuthenticatedUser user = client.findUser(this.getUsername(params));
        if (user == null) {
            throw new OAuthException(OAuthError.invalid_request, "Authenticated user not found.", null);
        }
        String password = this.getPassword(params);
        if (!SecretVerifier.compare((char[])user.getPassword(), (char[])password.toCharArray())) {
            throw new OAuthException(OAuthError.invalid_grant, "Password not correct.", null);
        }
        String[] requestedScope = this.getScope(params);
        this.refreshUserScopesAndPersist(user, requestedScope);
        Token token = this.generator.generateToken(user, this.tokenTimeSec);
        return this.responseTokenRepresentation(token, Scopes.toString(requestedScope));
    }

    private Representation doRefreshFlow(Client client, Form params) throws OAuthException {
        Token token = this.generator.findToken(this.getRefreshToken(params));
        if (token != null && token instanceof ExpireToken) {
            AuthenticatedUser user = token.getUser();
            if (client.containsUser(user.getId())) {
                String scope = params.getFirstValue("scope");
                if (scope != null && !scope.isEmpty()) {
                    String[] requestedScopes = Scopes.parseScope(scope);
                    String[] grantedScopes = Scopes.parseScope(user.getGrantedRoles());
                    if (!Arrays.asList(grantedScopes).containsAll(Arrays.asList(requestedScopes))) {
                        throw new OAuthException(OAuthError.invalid_scope, "Requested scopes contains which is not originally granted by the resource owner.", null);
                    }
                    this.refreshUserScopesAndPersist(user, requestedScopes);
                }
                this.generator.refreshToken((ExpireToken)token);
                return this.responseTokenRepresentation(token, scope);
            }
            throw new OAuthException(OAuthError.unauthorized_client, "User does not match.", null);
        }
        throw new OAuthException(OAuthError.invalid_grant, "Refresh token.", null);
    }

    private void refreshUserScopesAndPersist(AuthenticatedUser user, String[] scopes) {
        user.revokeRoles();
        for (String s : scopes) {
            user.addRole(this.getRole(s), "");
        }
        user.persist();
    }
}

