/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.memory.ExpireToken;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TokenAuthServerResource
extends OAuthServerResource {
    public static final String LOCAL_ACCESS_ONLY = "localOnly";

    private boolean isLocalAcessOnly() {
        String lo = (String)this.getContext().getAttributes().get(LOCAL_ACCESS_ONLY);
        return lo != null && lo.length() > 0 && Boolean.parseBoolean(lo);
    }

    protected void doCatch(Throwable t) {
        OAuthException oex = OAuthException.toOAuthException(t);
        this.getResponse().setStatus(Status.SUCCESS_OK);
        this.getResponse().setEntity(TokenAuthServerResource.responseErrorRepresentation(oex));
    }

    @Post(value="json")
    public Representation authenticate(Representation input) throws Exception {
        JSONObject call;
        this.getLogger().fine("In Authenticate resource");
        if (this.isLocalAcessOnly()) {
            String scheme = this.getOriginalRef().getScheme();
            if (!Protocol.RIAP.getSchemeName().equals(scheme)) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Auth server only allows local resource validation");
            }
        }
        if (!(call = new JsonRepresentation(input).getJsonObject()).has("token_type")) {
            throw new OAuthException(OAuthError.invalid_request, "No token_type", null);
        }
        String tokenType = call.getString("token_type");
        if (!tokenType.equals("Bearer")) {
            throw new OAuthException(OAuthError.invalid_request, "Unsupported token_type", null);
        }
        Token token = this.validateBearerToken(call);
        AuthenticatedUser user = token.getUser();
        if (user == null) {
            throw new OAuthException(OAuthError.invalid_token, "AuthenticatedUser not found", null);
        }
        String scope = Scopes.toScope(user.getGrantedRoles());
        JSONObject resp = new JSONObject();
        resp.put("username", (Object)user.getId());
        resp.put("scope", (Object)scope);
        return new JsonRepresentation(resp);
    }

    private Token validateBearerToken(JSONObject call) throws JSONException, OAuthException {
        ExpireToken et;
        String token = call.get("access_token").toString();
        this.getLogger().fine("In Validator resource - searching for token = " + token);
        Token t = this.generator.findToken(token);
        if (t == null) {
            throw new OAuthException(OAuthError.invalid_token, "Token not found.", null);
        }
        this.getLogger().fine("In Validator resource - got token = " + t);
        if (t instanceof ExpireToken && !token.equals((et = (ExpireToken)t).getToken())) {
            this.getLogger().warning("Should not use the refresh_token to sign!");
            throw new OAuthException(OAuthError.invalid_token, "Invalid Token.", null);
        }
        return t;
    }
}

