/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.net.URI;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.CookieSetting;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.resource.ClientResource;

public class CookieCopyClientResource
extends ClientResource {
    private volatile boolean copyCookies = true;

    public CookieCopyClientResource() {
    }

    public CookieCopyClientResource(ClientResource resource) {
        super(resource);
    }

    public CookieCopyClientResource(Context context, Method method, Reference reference) {
        super(context, method, reference);
    }

    public CookieCopyClientResource(Context context, Method method, String uri) {
        super(context, method, uri);
    }

    public CookieCopyClientResource(Context context, Method method, URI uri) {
        super(context, method, uri);
    }

    public CookieCopyClientResource(Context context, Reference reference) {
        super(context, reference);
    }

    public CookieCopyClientResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public CookieCopyClientResource(Context context, String uri) {
        super(context, uri);
    }

    public CookieCopyClientResource(Context context, URI uri) {
        super(context, uri);
    }

    public CookieCopyClientResource(Method method, Reference reference) {
        super(method, reference);
    }

    public CookieCopyClientResource(Method method, String uri) {
        super(method, uri);
    }

    public CookieCopyClientResource(Method method, URI uri) {
        super(method, uri);
    }

    public CookieCopyClientResource(Reference reference) {
        super(reference);
    }

    public CookieCopyClientResource(Request request, Response response) {
        super(request, response);
    }

    public CookieCopyClientResource(String uri) {
        super(uri);
    }

    public CookieCopyClientResource(URI uri) {
        super(uri);
    }

    public boolean getCopyCookies() {
        return this.copyCookies;
    }

    protected void redirect(Request request, Response response, List<Reference> references, int retryAttempt, Uniform next) {
        if (retryAttempt < 0) {
            for (CookieSetting cs : response.getCookieSettings()) {
                request.getCookies().add(cs.getName(), cs.getValue());
            }
        }
        super.redirect(request, response, references, retryAttempt, next);
    }

    public void setCopyCookies(boolean copyCookies) {
        this.copyCookies = copyCookies;
    }
}

