/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.concurrent.ScheduledFuture;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.internal.Token;

public class ExpireToken
implements Token {
    private final long expirePeriod;
    private final String refreshToken;
    private final AuthenticatedUser user;
    private volatile String token;
    private volatile ScheduledFuture<?> future;

    public ExpireToken(String refreshToken, long expTimeSec, String token, AuthenticatedUser user) {
        this.refreshToken = refreshToken;
        this.token = token;
        this.user = user;
        this.expirePeriod = expTimeSec;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    @Override
    public long getExpirePeriod() {
        return this.expirePeriod;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void expireToken() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.token = null;
    }

    @Override
    public AuthenticatedUser getUser() {
        return this.user;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExpireToken) {
            ExpireToken t = (ExpireToken)obj;
            return this.refreshToken.equals(t.refreshToken) && this.expirePeriod == t.expirePeriod;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.getRefreshToken(), this.getExpirePeriod()});
    }
}

