/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.edm;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.restlet.Context;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Schema;
import org.restlet.ext.odata.internal.edm.Type;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static final List<String> dateTimeFormats = Arrays.asList("yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "EEE, dd MMM yyyy HH:mm:ss zzz");
    public static final NumberFormat decimalFormat = DecimalFormat.getNumberInstance(Locale.US);
    public static final NumberFormat doubleFormat = DecimalFormat.getNumberInstance(Locale.US);
    public static final NumberFormat singleFormat = DecimalFormat.getNumberInstance(Locale.US);
    public static final NumberFormat timeFormat = DecimalFormat.getIntegerInstance(Locale.US);

    public static Object fromEdm(String value, String adoNetType) {
        if (value == null) {
            return null;
        }
        Object result = null;
        try {
            if (adoNetType.endsWith("Binary")) {
                result = value.getBytes();
            } else if (adoNetType.endsWith("Boolean")) {
                result = Boolean.valueOf(value);
            } else if (adoNetType.endsWith("DateTime")) {
                result = DateUtils.parse((String)value, dateTimeFormats);
            } else if (adoNetType.endsWith("DateTimeOffset")) {
                result = DateUtils.parse((String)value, dateTimeFormats);
            } else if (adoNetType.endsWith("Time")) {
                result = timeFormat.parseObject(value);
            } else if (adoNetType.endsWith("Decimal")) {
                result = decimalFormat.parseObject(value);
            } else if (adoNetType.endsWith("Single")) {
                result = singleFormat.parseObject(value);
            } else if (adoNetType.endsWith("Double")) {
                result = doubleFormat.parseObject(value);
            } else if (adoNetType.endsWith("Guid")) {
                result = value;
            } else if (adoNetType.endsWith("Int16")) {
                result = Short.valueOf(value);
            } else if (adoNetType.endsWith("Int32")) {
                result = Integer.valueOf(value);
            } else if (adoNetType.endsWith("Int64")) {
                result = Long.valueOf(value);
            } else if (adoNetType.endsWith("Byte")) {
                result = Byte.valueOf(value);
            } else if (adoNetType.endsWith("String")) {
                result = value;
            }
        }
        catch (Exception e) {
            Context.getCurrentLogger().warning("Cannot convert " + value + " from this EDM type " + adoNetType);
        }
        return result;
    }

    public static String getFullClassName(String name) {
        StringBuilder builder = new StringBuilder();
        int index = name.lastIndexOf(".");
        if (index > -1) {
            builder.append(TypeUtils.getPackageName(ReflectUtils.normalize(name.substring(0, index))));
            builder.append(name.substring(index));
        } else {
            builder.append(name);
        }
        return builder.toString();
    }

    public static Class<?> getJavaClass(EntityType type) {
        Class<?> result = null;
        String fullClassName = TypeUtils.getPackageName(type.getSchema()) + "." + type.getClassName();
        try {
            result = Class.forName(fullClassName);
        }
        catch (ClassNotFoundException e) {
            Context.getCurrentLogger().warning("Can't find the following class in the class loader: " + fullClassName);
        }
        return result;
    }

    public static String getLiteralForm(String value, String adoNetType) {
        if (value == null) {
            return null;
        }
        String result = null;
        try {
            if (adoNetType.endsWith("Binary")) {
                result = "'" + value + "'";
            } else if (adoNetType.endsWith("DateTime")) {
                result = "datetime'" + value + "'";
            } else if (adoNetType.endsWith("DateTimeOffset")) {
                result = "datetimeoffset'" + value + "'";
            } else if (adoNetType.endsWith("Time")) {
                result = "time'" + value + "'";
            } else if (adoNetType.endsWith("Guid")) {
                result = "guid'" + value + "'";
            } else if (adoNetType.endsWith("String")) {
                result = "'" + value + "'";
            }
        }
        catch (Exception e) {
            Context.getCurrentLogger().warning("Cannot convert " + value + " from this EDM type " + adoNetType);
        }
        return result;
    }

    public static String getPackageName(Schema schema) {
        return TypeUtils.getPackageName(schema.getNamespace().getName());
    }

    public static String getPackageName(String name) {
        StringBuilder builder = new StringBuilder();
        String[] tab = name.split("\\.");
        for (int i = 0; i < tab.length; ++i) {
            String string = tab[i];
            if (i > 0) {
                builder.append(".");
            }
            builder.append(string.toLowerCase());
        }
        return builder.toString();
    }

    public static String toEdm(Object value, Type type) {
        String adoNetType = type.getName();
        if (value == null && adoNetType == null) {
            return null;
        }
        String result = null;
        if (adoNetType.endsWith("Binary")) {
            if (byte[].class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmBinary((byte[])value);
            }
        } else if (adoNetType.endsWith("Boolean")) {
            if (Boolean.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmBoolean((Boolean)value);
            }
        } else if (adoNetType.endsWith("DateTime")) {
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDateTime((Date)value);
            }
        } else if (adoNetType.endsWith("DateTimeOffset")) {
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDateTime((Date)value);
            }
        } else if (adoNetType.endsWith("Time")) {
            if (Long.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmTime((Long)value);
            }
        } else if (adoNetType.endsWith("Decimal")) {
            if (Double.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDecimal((Double)value);
            }
        } else if (adoNetType.endsWith("Single")) {
            if (Float.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmSingle(((Float)value).floatValue());
            }
        } else if (adoNetType.endsWith("Double")) {
            if (Double.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDouble((Double)value);
            }
        } else if (adoNetType.endsWith("Guid")) {
            result = value.toString();
        } else if (adoNetType.endsWith("Int16")) {
            if (Short.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt16((Short)value);
            }
        } else if (adoNetType.endsWith("Int32")) {
            if (Integer.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt32((Integer)value);
            }
        } else if (adoNetType.endsWith("Int64")) {
            if (Long.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt64((Long)value);
            }
        } else if (adoNetType.endsWith("Byte")) {
            if (Byte.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmByte((Byte)value);
            }
        } else if (adoNetType.endsWith("String")) {
            result = value.toString();
        }
        if (result == null) {
            result = value.toString();
        }
        return result;
    }

    public static String toEdmBinary(byte[] value) {
        return new String(value);
    }

    public static String toEdmBoolean(boolean value) {
        return Boolean.toString(value);
    }

    public static String toEdmByte(byte value) {
        return Byte.toString(value);
    }

    public static String toEdmDateTime(Date value) {
        return DateUtils.format((Date)value, (String)dateTimeFormats.get(0));
    }

    public static String toEdmDecimal(double value) {
        return decimalFormat.format(value);
    }

    public static String toEdmDouble(double value) {
        return doubleFormat.format(value);
    }

    public static String toEdmInt16(short value) {
        return Short.toString(value);
    }

    public static String toEdmInt32(int value) {
        return Integer.toString(value);
    }

    public static String toEdmInt64(long value) {
        return Long.toString(value);
    }

    public static String toEdmKey(Object value, Type type) {
        String adoNetType = type.getName();
        if (value == null && adoNetType == null) {
            return null;
        }
        String result = null;
        if (adoNetType.endsWith("Binary")) {
            if (byte[].class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmBinary((byte[])value);
            }
        } else if (adoNetType.endsWith("Boolean")) {
            if (Boolean.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmBoolean((Boolean)value);
            }
        } else if (adoNetType.endsWith("DateTime")) {
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDateTime((Date)value);
            }
        } else if (adoNetType.endsWith("DateTimeOffset")) {
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDateTime((Date)value);
            }
        } else if (adoNetType.endsWith("Time")) {
            if (Long.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmTime((Long)value);
            }
        } else if (adoNetType.endsWith("Decimal")) {
            if (Double.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDecimal((Double)value);
            }
        } else if (adoNetType.endsWith("Single")) {
            if (Float.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmSingle(((Float)value).floatValue());
            }
        } else if (adoNetType.endsWith("Double")) {
            if (Double.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmDouble((Double)value);
            }
        } else if (adoNetType.endsWith("Guid")) {
            result = value.toString();
        } else if (adoNetType.endsWith("Int16")) {
            if (Short.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt16((Short)value);
            }
        } else if (adoNetType.endsWith("Int32")) {
            if (Integer.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt32((Integer)value);
            }
        } else if (adoNetType.endsWith("Int64")) {
            if (Long.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmInt64((Long)value);
            }
        } else if (adoNetType.endsWith("Byte")) {
            if (Byte.class.isAssignableFrom(value.getClass())) {
                result = TypeUtils.toEdmByte((Byte)value);
            }
        } else if (adoNetType.endsWith("String")) {
            result = "'" + value.toString() + "'";
        }
        if (result == null) {
            result = value.toString();
        }
        return result;
    }

    public static String toEdmSingle(float value) {
        return singleFormat.format(value);
    }

    public static String toEdmTime(long value) {
        return timeFormat.format(value);
    }
}

