/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.edm.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    private static final Logger logger = Context.getCurrentLogger();
    private static final List<String> reservedWords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "switch", "synchronized", "this", "throw", "transient", "try", "void", "volatile", "while");

    public static Class<?> getEntryClass(Feed feed) {
        Class<?> result = null;
        if (feed != null && feed.getEntries() != null && !feed.getEntries().isEmpty()) {
            for (Entry entry : feed.getEntries()) {
                if (entry.getCategories() == null || entry.getCategories().isEmpty()) continue;
                Category category = (Category)entry.getCategories().get(0);
                try {
                    result = Class.forName(TypeUtils.getFullClassName(category.getTerm()));
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        return result;
    }

    public static Class<?> getSimpleClass(Object entity, String propertyName) {
        Class result = null;
        String normPteName = ReflectUtils.normalize(propertyName);
        try {
            Field field = entity.getClass().getDeclaredField(normPteName);
            if (field.getType().isArray()) {
                result = field.getType().getComponentType();
            } else {
                Type genericFieldType = field.getGenericType();
                if (genericFieldType instanceof ParameterizedType) {
                    ParameterizedType aType = (ParameterizedType)genericFieldType;
                    Type[] fieldArgTypes = aType.getActualTypeArguments();
                    if (fieldArgTypes.length == 1) {
                        result = (Class)fieldArgTypes[0];
                    }
                } else {
                    result = field.getType();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't access to the following property " + normPteName + " on " + entity.getClass() + ".", e);
        }
        return result;
    }

    public static Object invokeGetter(Object entity, String propertyName) throws Exception {
        Object result = null;
        if (propertyName != null && entity != null) {
            propertyName = propertyName.replaceAll("/", ".");
            Object o = entity;
            String pty = propertyName;
            int index = propertyName.indexOf(".");
            if (index != -1) {
                o = ReflectUtils.invokeGetter(entity, propertyName.substring(0, index));
                pty = propertyName.substring(index + 1);
                result = ReflectUtils.invokeGetter(o, pty);
            } else {
                String getterName = null;
                char firstLetter = propertyName.charAt(0);
                getterName = Character.isLowerCase(firstLetter) ? "get" + Character.toUpperCase(firstLetter) + pty.substring(1) : "get" + pty;
                Method getter = null;
                for (int i = 0; getter == null && i < entity.getClass().getDeclaredMethods().length; ++i) {
                    Method method = entity.getClass().getDeclaredMethods()[i];
                    if (!method.getName().equals(getterName)) continue;
                    getter = method;
                }
                if (getter != null) {
                    result = getter.invoke(o, new Object[0]);
                }
            }
        }
        return result;
    }

    public static void invokeSetter(Object entity, String propertyName, Object propertyValue) throws Exception {
        if (propertyName != null && entity != null) {
            propertyName = propertyName.replaceAll("/", ".");
            Object o = entity;
            String pty = propertyName;
            String[] strings = propertyName.split("\\.");
            if (strings.length > 1) {
                for (int i = 0; i < strings.length - 1; ++i) {
                    String string = strings[i];
                    Object p = ReflectUtils.invokeGetter(o, string);
                    if (p == null) {
                        Field[] fields;
                        for (Field field : fields = o.getClass().getDeclaredFields()) {
                            if (!field.getName().equalsIgnoreCase(string)) continue;
                            p = field.getType().newInstance();
                            break;
                        }
                    }
                    o = p;
                }
                pty = strings[strings.length - 1];
            }
            String setterName = null;
            char firstLetter = pty.charAt(0);
            setterName = Character.isLowerCase(firstLetter) ? "set" + Character.toUpperCase(firstLetter) + pty.substring(1) : "set" + pty;
            Method setter = null;
            for (int i = 0; setter == null && i < o.getClass().getDeclaredMethods().length; ++i) {
                Method method = o.getClass().getDeclaredMethods()[i];
                if (!method.getName().equals(setterName) || method.getParameterTypes() == null || method.getParameterTypes().length != 1) continue;
                setter = method;
            }
            if (setter != null) {
                setter.invoke(o, propertyValue);
            }
        }
    }

    public static void invokeSetter(Object entity, String propertyName, String propertyValue, String propertyType) throws Exception {
        if (propertyName != null) {
            propertyName = propertyName.replaceAll("/", ".");
            Object o = entity;
            String pty = propertyName;
            String[] strings = propertyName.split("\\.");
            if (strings.length > 1) {
                for (int i = 0; i < strings.length - 1; ++i) {
                    String string = strings[i];
                    Object p = ReflectUtils.invokeGetter(o, string);
                    if (p == null) {
                        Field[] fields;
                        for (Field field : fields = o.getClass().getDeclaredFields()) {
                            if (!field.getName().equalsIgnoreCase(string)) continue;
                            p = field.getType().newInstance();
                            break;
                        }
                    }
                    o = p;
                }
                pty = strings[strings.length - 1];
            }
            String setterName = null;
            char firstLetter = propertyName.charAt(0);
            setterName = Character.isLowerCase(firstLetter) ? "set" + Character.toUpperCase(firstLetter) + pty.substring(1) : "set" + pty;
            Method setter = null;
            Object setterParameter = null;
            for (int i = 0; setter == null && i < o.getClass().getDeclaredMethods().length; ++i) {
                Method method = o.getClass().getDeclaredMethods()[i];
                if (!method.getName().equals(setterName) || method.getParameterTypes() == null || method.getParameterTypes().length != 1) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                if (String.class.equals(parameterType)) {
                    setterParameter = propertyValue;
                    setter = method;
                    continue;
                }
                if (Integer.class.equals(parameterType)) {
                    setterParameter = Integer.valueOf(propertyValue);
                    setter = method;
                    continue;
                }
                if (!Integer.TYPE.equals(parameterType)) continue;
                setterParameter = Integer.valueOf(propertyValue);
                setter = method;
            }
            if (setter != null) {
                setter.invoke(o, setterParameter);
            }
        }
    }

    public static boolean isReservedWord(String name) {
        return reservedWords.contains(name);
    }

    public static String normalize(String name) {
        String result = null;
        if (name != null) {
            StringBuilder b = new StringBuilder();
            boolean upperCase = false;
            char oldChar = '\u0000';
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isDigit(c)) {
                    b.append(c);
                    oldChar = c;
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    if (upperCase) {
                        b.append(Character.toUpperCase(c));
                        upperCase = false;
                    } else {
                        b.append(c);
                    }
                    oldChar = c;
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    if (upperCase) {
                        b.append(c);
                        upperCase = false;
                    } else if (oldChar != '\u0000' && Character.isLowerCase(oldChar)) {
                        b.append(c);
                    } else {
                        b.append(Character.toLowerCase(c));
                    }
                    oldChar = c;
                    continue;
                }
                if (c == '.') {
                    upperCase = true;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    b.append(c);
                    oldChar = c;
                    continue;
                }
                upperCase = true;
            }
            result = b.toString();
        }
        return result;
    }

    public static void setProperty(Object entity, Property property, String propertyValue) throws Exception {
        ReflectUtils.invokeSetter(entity, property.getNormalizedName(), TypeUtils.fromEdm(propertyValue, property.getType().getName()));
    }

    public static void setProperty(Object entity, String propertyName, boolean isCollection, Iterator<?> iterator, Class<?> propertyClass) throws Exception {
        block10: {
            String normPteName;
            block8: {
                Field field;
                block11: {
                    ArrayList list;
                    boolean isGeneric;
                    block9: {
                        normPteName = ReflectUtils.normalize(propertyName);
                        if (iterator == null || !iterator.hasNext()) {
                            return;
                        }
                        isGeneric = false;
                        boolean isArray = false;
                        field = entity.getClass().getDeclaredField(normPteName);
                        if (field.getType().isArray()) {
                            isArray = true;
                        } else {
                            ParameterizedType aType;
                            Type[] fieldArgTypes;
                            Type genericFieldType = field.getGenericType();
                            if (genericFieldType instanceof ParameterizedType && (fieldArgTypes = (aType = (ParameterizedType)genericFieldType).getActualTypeArguments()).length == 1) {
                                isGeneric = true;
                            }
                        }
                        if (!isCollection) break block8;
                        if (!isArray) break block9;
                        list = new ArrayList();
                        while (iterator.hasNext()) {
                            list.add(iterator.next());
                        }
                        ReflectUtils.invokeSetter(entity, normPteName, list.toArray());
                        break block10;
                    }
                    if (!isGeneric) break block10;
                    if (!List.class.isAssignableFrom(field.getType())) break block11;
                    list = new ArrayList();
                    while (iterator.hasNext()) {
                        list.add(iterator.next());
                    }
                    ReflectUtils.invokeSetter(entity, normPteName, list);
                    break block10;
                }
                if (!Set.class.isAssignableFrom(field.getType())) break block10;
                TreeSet set = new TreeSet();
                while (iterator.hasNext()) {
                    set.add(iterator.next());
                }
                ReflectUtils.invokeSetter(entity, normPteName, set);
                break block10;
            }
            while (iterator.hasNext()) {
                Object property = iterator.next();
                ReflectUtils.invokeSetter(entity, normPteName, property);
            }
        }
    }

    public static void setProperty(Object entity, String propertyName, String propertyValue) throws Exception {
        int colonIndex = propertyName.indexOf(58);
        if (colonIndex != -1) {
            propertyName = propertyName.substring(colonIndex + 1);
        }
        ReflectUtils.invokeSetter(entity, propertyName, propertyValue, null);
    }
}

