/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.restlet.data.MediaType;
import org.restlet.engine.Edition;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomRepresentation
extends XmlRepresentation {
    private volatile Document document;
    private volatile boolean indenting;
    private volatile Representation xmlRepresentation;

    public DomRepresentation() throws IOException {
        this(MediaType.TEXT_XML);
    }

    public DomRepresentation(MediaType mediaType) throws IOException {
        super(mediaType);
        this.document = this.getDocumentBuilder().newDocument();
    }

    public DomRepresentation(MediaType mediaType, Document xmlDocument) {
        super(mediaType);
        this.document = xmlDocument;
    }

    public DomRepresentation(Representation xmlRepresentation) {
        super(xmlRepresentation == null ? null : xmlRepresentation.getMediaType());
        this.setAvailable(xmlRepresentation.isAvailable());
        this.xmlRepresentation = xmlRepresentation;
    }

    protected Transformer createTransformer() throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", this.isIndenting() ? "yes" : "no");
            DocumentType docType = this.getDocument().getDoctype();
            if (docType != null) {
                if (docType.getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", this.getDocument().getDoctype().getSystemId());
                }
                if (docType.getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", this.getDocument().getDoctype().getPublicId());
                }
            }
            return transformer;
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Couldn't write the XML representation: " + tce.getMessage());
        }
    }

    public Document getDocument() throws IOException {
        if (this.document == null) {
            if (this.xmlRepresentation != null) {
                try {
                    this.document = this.getDocumentBuilder().parse(this.getInputSource());
                }
                catch (SAXException se) {
                    throw new IOException("Couldn't read the XML representation. " + se.getMessage());
                }
            } else {
                this.document = this.getDocumentBuilder().newDocument();
            }
        }
        return this.document;
    }

    public DOMSource getDomSource() throws IOException {
        return new DOMSource(this.getDocument());
    }

    public InputSource getInputSource() throws IOException {
        if (this.xmlRepresentation.isAvailable()) {
            return new InputSource(this.xmlRepresentation.getStream());
        }
        return new InputSource((InputStream)null);
    }

    @Deprecated
    public boolean isIndent() {
        return this.indenting;
    }

    public boolean isIndenting() {
        return this.isIndent();
    }

    public void release() {
        this.setDocument(null);
        if (this.xmlRepresentation != null) {
            this.xmlRepresentation.release();
        }
        super.release();
    }

    public void setDocument(Document dom) {
        this.document = dom;
    }

    @Deprecated
    public void setIndent(boolean indenting) {
        this.indenting = indenting;
    }

    public void setIndenting(boolean indenting) {
        this.setIndent(indenting);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (Edition.CURRENT == Edition.ANDROID) {
            throw new UnsupportedOperationException("Instances of DomRepresentation cannot be written at this time.");
        }
        try {
            if (this.getDocument() != null) {
                Transformer transformer = this.createTransformer();
                transformer.transform(new DOMSource(this.getDocument()), new StreamResult(outputStream));
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Couldn't write the XML representation: " + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new IOException("Couldn't write the XML representation: " + te.getMessage());
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new IOException("Couldn't write the XML representation: " + tfce.getMessage());
        }
    }
}

