/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xstream;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.xstream.XstreamRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XstreamConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    protected <T> XstreamRepresentation<T> create(MediaType mediaType, T source) {
        return new XstreamRepresentation<T>(mediaType, source);
    }

    protected <T> XstreamRepresentation<T> create(Representation source) {
        return new XstreamRepresentation(source);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source) || VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, XstreamRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof XstreamRepresentation) {
            result = 1.0f;
        } else if (VARIANT_JSON.isCompatible(target)) {
            result = 0.8f;
        } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target)) {
            result = 0.8f;
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null) {
            if (VARIANT_JSON.isCompatible((Variant)source)) {
                result = 0.8f;
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible((Variant)source) || VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source)) {
                result = 0.8f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        T result = null;
        if (source instanceof XstreamRepresentation) {
            result = ((XstreamRepresentation)source).getObject();
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            result = this.create(source).getObject();
        } else if (VARIANT_APPLICATION_ALL_XML.isCompatible((Variant)source) || VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source)) {
            result = this.create(source).getObject();
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        XstreamRepresentation<Object> result = null;
        if (source instanceof XstreamRepresentation) {
            result = (XstreamRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.TEXT_XML);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                XstreamRepresentation<Object> xstreamRepresentation;
                result = xstreamRepresentation = this.create(target.getMediaType(), source);
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target)) {
                result = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }
}

