/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.geo.Point;
import com.google.gdata.util.common.xml.XmlNamespace;

public abstract class PointConstruct
extends ValueConstruct
implements Point {
    private Double lat;
    private Double lon;

    public PointConstruct(XmlNamespace namespace, String name) {
        super(namespace, name, null);
        this.setRequired(false);
    }

    public PointConstruct(XmlNamespace namespace, String name, Double lat, Double lon) {
        super(namespace, name, null);
        if (lat == null && lon == null) {
            this.setRequired(false);
        }
        this.setGeoLocation(lat, lon);
    }

    public PointConstruct(XmlNamespace namespace, String name, Point copyFrom) {
        this(namespace, name, copyFrom == null ? null : copyFrom.getLatitude(), copyFrom == null ? null : copyFrom.getLongitude());
    }

    @Override
    public Double getLatitude() {
        return this.lat;
    }

    @Override
    public Double getLongitude() {
        return this.lon;
    }

    @Override
    public void setGeoLocation(Double lat, Double lon) {
        if (lat != null && lon != null) {
            if (lat.compareTo(-90.0) < 0 || lat.compareTo(90.0) > 0) {
                throw new IllegalArgumentException("Latitude must be between -90 and 90 degrees.");
            }
            if (lon.compareTo(-180.0) < 0 || lon.compareTo(180.0) > 0) {
                throw new IllegalArgumentException("Longitude must be between -180 and 180 degrees.");
            }
        } else if (lat != null || lon != null) {
            throw new IllegalArgumentException("latitude and longitude must either both be null or non-null.");
        }
        this.lat = lat;
        this.lon = lon;
        super.setValue(this.toString());
    }

    public String toString() {
        if (this.lat != null && this.lon != null) {
            return this.lat + " " + this.lon;
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        Double lat = null;
        Double lon = null;
        if (v != null) {
            int space = (v = v.trim()).indexOf(32);
            if (space == -1) {
                throw this.createInvalidValueException();
            }
            String latString = v.substring(0, space);
            String lonString = v.substring(space + 1);
            try {
                lat = Double.valueOf(latString);
                lon = Double.valueOf(lonString);
            }
            catch (NumberFormatException e) {
                throw this.createInvalidValueException();
            }
        }
        this.setGeoLocation(lat, lon);
    }

    @Override
    protected void validate() throws IllegalStateException {
        super.validate();
        if (this.lat == null && this.lon != null || this.lat != null && this.lon == null) {
            throw new IllegalStateException("latitude and longitude must either both be null or non-null.");
        }
    }

    private IllegalArgumentException createInvalidValueException() {
        return new IllegalArgumentException("Format of a coordinate is \"latitude longitude\", where latitude and longitude are doubles, separated by a space.");
    }
}

