/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.routing.Router;
import org.restlet.test.RestletTestCase;
import org.restlet.test.engine.UserAgentTestResource;

public class UserAgentTunnelFilterTestCase
extends RestletTestCase {
    private static final String URL = "http://localhost:" + TEST_PORT + "/test";
    private Application application;

    private Request createRequest() {
        Request request = new Request();
        request.setMethod(Method.GET);
        request.getClientInfo().setAgent("msie/1.1");
        request.setResourceRef(URL);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_XML));
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        return request;
    }

    public void setUp() {
        this.application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attachDefault(UserAgentTestResource.class);
                return router;
            }
        };
    }

    public void testTunnelOff() {
        this.application.getTunnelService().setUserAgentTunnel(false);
        Request request = this.createRequest();
        Response response = new Response(request);
        this.application.handle(request, response);
        UserAgentTunnelFilterTestCase.assertEquals((Object)response.getStatus(), (Object)Status.SUCCESS_OK);
        UserAgentTunnelFilterTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)response.getEntity().getMediaType());
    }

    public void testTunnelOn() {
        this.application.getTunnelService().setUserAgentTunnel(true);
        Request request = this.createRequest();
        Response response = new Response(request);
        this.application.handle(request, response);
        UserAgentTunnelFilterTestCase.assertEquals((Object)response.getStatus(), (Object)Status.SUCCESS_OK);
        UserAgentTunnelFilterTestCase.assertEquals((Object)MediaType.TEXT_HTML, (Object)response.getEntity().getMediaType());
    }
}

