/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.RuntimeDelegate;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.restlet.data.Reference;
import org.restlet.ext.jaxrs.ExtendedUriBuilder;
import org.restlet.ext.jaxrs.internal.core.UriBuilderImpl;
import org.restlet.test.jaxrs.services.car.CarListResource;
import org.restlet.test.jaxrs.services.car.CarResource;
import org.restlet.test.jaxrs.services.resources.SimpleTrain;

public class UriBuilderImplTest
extends TestCase {
    private static final String TEMPL_VARS_EXPECTED = "abc://username:password@www.secure.org:8080/def/ghi;jkl=mno/pqr;stu=vwx?ABC=DEF&GHI=JKL#MNO";
    private static final URI URI_1;
    private UriBuilder uriBuilder;
    private UriBuilder uriBuilderWithVars;

    static void assertEqualsURI(String expectedUri, URI actualUri) throws URISyntaxException {
        UriBuilderImplTest.assertEquals((String)expectedUri, (String)actualUri.toString());
        UriBuilderImplTest.assertEquals((Object)new URI(expectedUri), (Object)actualUri);
    }

    static void assertEqualsURI(String expectedUri, UriBuilder actualBuilder) throws Exception {
        UriBuilderImplTest.assertEqualsURI(expectedUri, actualBuilder, true);
    }

    static void assertEqualsURI(String expectedUri, UriBuilder actualBuilder, boolean encode) throws Exception {
        URI actual = encode ? actualBuilder.buildFromEncoded(new Object[0]) : actualBuilder.build(new Object[0]);
        UriBuilderImplTest.assertEqualsURI(expectedUri, actual);
    }

    static void assertEqualsUriSlashAllowed(String expectedUri, UriBuilder actual) throws URISyntaxException {
        try {
            UriBuilderImplTest.assertEqualsURI(expectedUri, actual.build(new Object[0]));
        }
        catch (AssertionFailedError ife) {
            UriBuilderImplTest.assertEqualsURI(expectedUri + "/", actual.build(new Object[0]));
        }
    }

    private static void assertEqualUriBuilder(String expectedScheme, String expectedUserInfo, String expectedHost, String expectedPort, String expectedPath, String expectedQuery, UriBuilder actualUriBuilder, boolean compareResult) throws Exception {
        if (actualUriBuilder.getClass().getPackage().getName().startsWith("org.restlet.ext.jaxrs")) {
            block17: {
                UriBuilderImplTest.assertEquals((String)expectedScheme, (String)UriBuilderImplTest.getScheme(actualUriBuilder));
                UriBuilderImplTest.assertEquals((String)expectedUserInfo, (String)UriBuilderImplTest.getUserInfo(actualUriBuilder));
                UriBuilderImplTest.assertEquals((String)expectedHost, (String)UriBuilderImplTest.getHost(actualUriBuilder));
                UriBuilderImplTest.assertEquals((String)expectedPort, (String)UriBuilderImplTest.getPort(actualUriBuilder));
                String actPath = UriBuilderImplTest.getPath(actualUriBuilder);
                try {
                    UriBuilderImplTest.assertEquals((String)expectedPath, (String)actPath);
                }
                catch (ComparisonFailure cf) {
                    if (expectedPath != null) break block17;
                    UriBuilderImplTest.assertEquals((String)"", (String)actPath);
                }
            }
            String actualQuery = UriBuilderImplTest.getQuery(actualUriBuilder);
            if (actualQuery != null) {
                actualQuery = actualQuery.toString();
            }
            UriBuilderImplTest.assertEquals((Object)expectedQuery, (Object)actualQuery);
        }
        if (compareResult) {
            UriBuilder expectedUriBuilder = RuntimeDelegate.getInstance().createUriBuilder();
            if (expectedScheme != null) {
                expectedUriBuilder.scheme(expectedScheme);
            }
            if (expectedUserInfo != null) {
                expectedUriBuilder.userInfo(expectedUserInfo);
            }
            if (expectedHost != null) {
                expectedUriBuilder.host(expectedHost);
            }
            if (expectedUriBuilder instanceof UriBuilderImpl) {
                ((UriBuilderImpl)expectedUriBuilder).port(expectedPort);
            } else if (expectedUriBuilder instanceof ExtendedUriBuilder) {
                ((ExtendedUriBuilder)expectedUriBuilder).port(expectedPort);
            } else if (expectedPort == null || expectedPort.equals("")) {
                expectedUriBuilder.port(-1);
            } else {
                try {
                    int portInt = Integer.valueOf(expectedPort);
                }
                catch (NumberFormatException e) {
                    System.out.println("Sorry, could not do this test with an expected port \"" + expectedPort + "\" and an UriBuilder of type " + expectedUriBuilder.getClass());
                }
            }
            expectedUriBuilder.path(expectedPath);
            if (expectedQuery != null) {
                expectedUriBuilder.replaceQuery(expectedQuery);
            }
            String expectedURI = expectedUriBuilder.build(new Object[0]).toString();
            String atualURI = actualUriBuilder.build(new Object[0]).toString();
            UriBuilderImplTest.assertEquals((String)expectedURI, (String)atualURI);
        }
    }

    static String getFieldValue(UriBuilder uriBuilder, String fieldName) throws Exception {
        Field queryField;
        try {
            queryField = uriBuilder.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            queryField = uriBuilder.getClass().getSuperclass().getDeclaredField(fieldName);
        }
        queryField.setAccessible(true);
        Object value = queryField.get(uriBuilder);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String getHost(UriBuilder uriBuilder) throws Exception {
        return UriBuilderImplTest.getFieldValue(uriBuilder, "host");
    }

    private static String getPath(UriBuilder uriBuilder) throws Exception {
        String path = UriBuilderImplTest.getFieldValue(uriBuilder, "path");
        if (path == null) {
            return null;
        }
        return path.toString();
    }

    private static String getPort(UriBuilder uriBuilder) throws Exception {
        return UriBuilderImplTest.getFieldValue(uriBuilder, "port");
    }

    private static String getQuery(UriBuilder uriBuilder) throws Exception {
        return UriBuilderImplTest.getFieldValue(uriBuilder, "query");
    }

    private static String getScheme(UriBuilder uriBuilder) throws Exception {
        return UriBuilderImplTest.getFieldValue(uriBuilder, "scheme");
    }

    private static String getUserInfo(UriBuilder uriBuilder) throws Exception {
        return UriBuilderImplTest.getFieldValue(uriBuilder, "userInfo");
    }

    public static void main(String[] args) {
        System.out.println(Reference.encode((String)"%"));
    }

    private URI buildFromTemplVarsWithMap(UriBuilder uriBuilder) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("scheme", "abc");
        vars.put("userInfo", "username:password");
        vars.put("host", "www.secure.org");
        vars.put("port", "8080");
        vars.put("path1", "def");
        vars.put("path2", "ghi");
        vars.put("mp2Name", "jkl");
        vars.put("mp2Value", "mno");
        vars.put("path3", "pqr");
        vars.put("mp3Name", "stu");
        vars.put("mp3Value", "vwx");
        vars.put("qp1Name", "ABC");
        vars.put("qp1Value", "DEF");
        vars.put("qp2Name", "GHI");
        vars.put("qp2Value", "JKL");
        vars.put("fragment", "MNO");
        return uriBuilder.buildFromMap(vars);
    }

    private URI buildFromTemplVarsWithStrings(UriBuilder uriBuilder) {
        return uriBuilder.build(new Object[]{"abc", "username:password", "www.secure.org", "8080", "def", "ghi", "jkl", "mno", "pqr", "stu", "vwx", "ABC", "DEF", "GHI", "JKL", "MNO"});
    }

    private void changeWithTemplVars(UriBuilderImpl uriBuilder) {
        uriBuilder.scheme("{scheme}");
        uriBuilder.userInfo("{userInfo}");
        uriBuilder.host("{host}");
        uriBuilder.port("{port}");
        uriBuilder.replacePath("{path1}");
        uriBuilder.path("{path2}");
        uriBuilder.replaceMatrix("{mp2Name}={mp2Value}");
        uriBuilder.path("{path3}");
        uriBuilder.matrixParam("{mp3Name}", new Object[]{"{mp3Value}"});
        uriBuilder.replaceQuery("{qp1Name}={qp1Value}");
        uriBuilder.queryParam("{qp2Name}", new Object[]{"{qp2Value}"});
        uriBuilder.fragment("{fragment}");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.uriBuilder = RuntimeDelegate.getInstance().createUriBuilder();
        this.uriBuilder.host("localhost");
        this.uriBuilder.segment(new String[]{"path1", "path2"});
        this.uriBuilder.scheme("http");
        this.uriBuilderWithVars = RuntimeDelegate.getInstance().createUriBuilder();
        this.uriBuilderWithVars.host("localhost");
        this.uriBuilderWithVars.scheme("http");
        this.uriBuilderWithVars.segment(new String[]{"abc", "{var1}", "def", "{var2}"});
    }

    protected void tearDown() throws Exception {
        this.uriBuilder = null;
        this.uriBuilderWithVars = null;
        super.tearDown();
    }

    public void testBuildFromArray() throws Exception {
        try {
            this.uriBuilderWithVars.build(new Object[]{"123"});
            UriBuilderImplTest.fail((String)"must fail, because there are not enough arguments");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URI uri = this.uriBuilderWithVars.build(new Object[]{"123", "456"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456", uri);
        UriBuilder uriBuilder2 = this.uriBuilderWithVars.clone();
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456", uriBuilder2.build(new Object[]{"123", "456"}));
        UriBuilderImplTest.assertEquals((String)this.uriBuilderWithVars.toString(), (String)uriBuilder2.toString());
        uriBuilder2.path("{var3}");
        uri = this.uriBuilderWithVars.build(new Object[]{"123", "456"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456", uri);
        try {
            uriBuilder2.build(new Object[]{"123", "456"});
            UriBuilderImplTest.fail((String)"must fail, because there are not enough arguments");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        URI uri2 = uriBuilder2.build(new Object[]{"123", "456", "789"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456/789", uri2);
    }

    public void testBuildFromEncoded() throws Exception {
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.buildFromEncoded(new Object[]{"a", "b"}));
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.buildFromEncoded(new Object[]{" ", "b"}));
        URI uri = this.uriBuilderWithVars.buildFromEncoded(new Object[]{"a", "b"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/a/def/b", uri);
        uri = this.uriBuilderWithVars.buildFromEncoded(new Object[]{"%20", "b"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/%20/def/b", uri);
        try {
            uri = this.uriBuilderWithVars.buildFromEncoded(new Object[]{" ", "b"});
            UriBuilderImplTest.fail((String)"must fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuildFromMap() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        try {
            this.uriBuilderWithVars.buildFromMap(vars);
            UriBuilderImplTest.fail((String)"must fail, because missing UriTemplate variables");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        vars.put("var1", "123");
        try {
            this.uriBuilderWithVars.buildFromMap(vars);
            UriBuilderImplTest.fail((String)"must fail, because missing UriTemplate variable");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        vars.put("var2", "456");
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456", this.uriBuilderWithVars.buildFromMap(vars));
        vars.put("var3", "789");
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/456", this.uriBuilderWithVars.buildFromMap(vars));
        vars.put("var2", " ");
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/123/def/%20", this.uriBuilderWithVars.buildFromMap(vars));
    }

    public void testBuildWithArgs() throws Exception {
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.build(new Object[]{"a", "b"}));
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.build(new Object[]{" ", "b"}));
        URI uri = this.uriBuilderWithVars.build(new Object[]{"a", "b"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/a/def/b", uri);
        uri = this.uriBuilderWithVars.build(new Object[]{"%20", "b"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/%2520/def/b", uri);
        uri = this.uriBuilderWithVars.build(new Object[]{" ", "b"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/abc/%20/def/b", uri);
    }

    public void testBuildWithoutArgs() throws Exception {
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.build(new Object[0]));
        try {
            this.uriBuilderWithVars.build(new Object[0]);
            UriBuilderImplTest.fail((String)"must fail, because vars are required");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClone() {
        UriBuilderImplTest.assertEquals((Object)this.uriBuilder.build(new Object[0]), (Object)this.uriBuilder.clone().build(new Object[0]));
    }

    public void testEncode() throws Exception {
        UriBuilder uriBuilder = RuntimeDelegate.getInstance().createUriBuilder();
        uriBuilder.host("www.xyz.de");
        uriBuilder.scheme("http");
        uriBuilder.segment(new String[]{"path1", "path2"});
        uriBuilder.path("hh ho");
        UriBuilderImplTest.assertEqualsURI("http://www.xyz.de/path1/path2/hh%20ho", uriBuilder, true);
    }

    public void testFragmentEnc() throws Exception {
        this.uriBuilder.fragment(String.valueOf('\t'));
        UriBuilderImplTest.assertEqualsURI(URI_1 + "#%09", this.uriBuilder, true);
        this.uriBuilder.fragment("anker");
        UriBuilderImplTest.assertEqualsURI(URI_1 + "#anker", this.uriBuilder, true);
    }

    public void testHostEnc() throws Exception {
        this.uriBuilder.host("test.domain.org");
        UriBuilderImplTest.assertEqualsURI("http://test.domain.org/path1/path2", this.uriBuilder, true);
        try {
            this.uriBuilder.host("test.domain .org a");
            UriBuilderImplTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        UriBuilderImplTest.assertEqualsURI("http://test.domain.org/path1/path2", this.uriBuilder, true);
    }

    public void testMatrixParam() throws Exception {
        this.uriBuilder.matrixParam("mp1", new Object[]{"mv1"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + ";mp1=mv1", this.uriBuilder, true);
        this.uriBuilder.matrixParam("mp1", new Object[]{"mv2"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + ";mp1=mv1;mp1=mv2", this.uriBuilder, true);
        this.uriBuilder.matrixParam("mp3", new Object[]{"mv3"});
        try {
            UriBuilderImplTest.assertEqualsURI(URI_1 + ";mp1=mv1;mp1=mv2;mp3=mv3", this.uriBuilder, true);
        }
        catch (AssertionFailedError afe) {
            UriBuilderImplTest.assertEqualsURI(URI_1 + ";mp3=mv3;mp1=mv1;mp1=mv2", this.uriBuilder, true);
        }
        this.uriBuilder.replaceMatrix("mp4=mv4");
        UriBuilderImplTest.assertEqualsURI(URI_1 + ";mp4=mv4", this.uriBuilder, true);
        this.uriBuilder.replaceMatrix("");
        UriBuilderImplTest.assertEquals((Object)new URI(URI_1 + ";"), (Object)this.uriBuilder.build(new Object[0]));
        this.uriBuilder.replaceMatrix(null);
        UriBuilderImplTest.assertEquals((Object)URI_1, (Object)this.uriBuilder.build(new Object[0]));
        this.uriBuilder.matrixParam("jkj$sdf", new Object[]{"ij a%20"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + ";jkj%24sdf=ij%20a%2520", this.uriBuilder, true);
    }

    public void testPathClass() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(SimpleTrain.class);
        UriBuilderImplTest.assertEqualsURI("http://localhost/train", this.uriBuilder, true);
    }

    public void testPathClassString() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(CarListResource.class, "getOffers");
        UriBuilderImplTest.assertEqualsURI("http://localhost/offers", this.uriBuilder, true);
    }

    public void testPathClassStringEnc() throws Exception {
        this.uriBuilder.replacePath(null);
        this.uriBuilder.path(CarListResource.class, "getOffers");
        UriBuilderImplTest.assertEqualsURI("http://localhost/offers", this.uriBuilder, true);
    }

    public void testPathMethodArray() throws Exception {
        this.uriBuilder.replacePath(null);
        Method findCar = CarListResource.class.getMethod("findCar", Integer.TYPE);
        Method engine = CarResource.class.getMethod("findEngine", new Class[0]);
        this.uriBuilder.path(CarListResource.class);
        this.uriBuilder.path(findCar).path(engine);
        UriBuilderImplTest.assertEqualsURI("http://localhost/cars/5/engine", this.uriBuilder.build(new Object[]{"5"}));
    }

    public void testPathStringArrayEnc() throws Exception {
        this.uriBuilder.segment(new String[]{"jjj", "kkk", "ll"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + "/jjj/kkk/ll", this.uriBuilder, true);
        this.uriBuilder.path("mno");
        UriBuilderImplTest.assertEqualsURI(URI_1 + "/jjj/kkk/ll/mno", this.uriBuilder, true);
        this.uriBuilder.path(" ");
        UriBuilderImplTest.assertEqualsURI(URI_1 + "/jjj/kkk/ll/mno/%20", this.uriBuilder, true);
    }

    public void testPort() throws Exception {
        this.uriBuilder.port(4711);
        UriBuilderImplTest.assertEqualsURI("http://localhost:4711/path1/path2", this.uriBuilder, true);
        this.uriBuilder.port(-1);
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2", this.uriBuilder, true);
    }

    public void testQueryEnc() throws Exception {
        this.uriBuilder.queryParam("qn", new Object[]{"qv"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + "?qn=qv", this.uriBuilder, true);
        this.uriBuilder.queryParam("qn", new Object[]{"qv2"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + "?qn=qv&qn=qv2", this.uriBuilder, true);
        this.uriBuilder.queryParam("qn3", new Object[]{"qv3"});
        UriBuilderImplTest.assertEqualsURI(URI_1 + "?qn=qv&qn=qv2&qn3=qv3", this.uriBuilder, true);
        this.uriBuilder.replaceQuery("qnNew=qvNew");
        UriBuilderImplTest.assertEqualsURI(URI_1 + "?qnNew=qvNew", this.uriBuilder, true);
        this.uriBuilder.replaceQuery(null);
        this.uriBuilder.queryParam("na$me", new Object[]{"George U."});
        UriBuilderImplTest.assertEqualsURI(URI_1 + "?na%24me=George%20U.", this.uriBuilder, true);
    }

    public void testreplaceMatrix() throws Exception {
        this.uriBuilder.matrixParam("a", new Object[]{"b"});
        this.uriBuilder.matrixParam("c", new Object[]{"d"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2;a=b;c=d", this.uriBuilder);
        this.uriBuilder.replaceMatrix("ksd hflk");
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2;ksd%20hflk", this.uriBuilder);
        this.uriBuilder.replaceMatrix("e=f");
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2;e=f", this.uriBuilder);
    }

    public void testReplacePath() throws Exception {
        this.uriBuilder.replacePath("newPath");
        UriBuilderImplTest.assertEqualsURI("http://localhost/newPath", this.uriBuilder);
        this.uriBuilder.replacePath("");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "localhost", null, "", null, this.uriBuilder, true);
        UriBuilderImplTest.assertEqualsUriSlashAllowed("http://localhost", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r t");
        UriBuilderImplTest.assertEqualsURI("http://localhost/gh/r%20t", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t");
        UriBuilderImplTest.assertEqualsURI("http://localhost/gh/r;t", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=6");
        UriBuilderImplTest.assertEqualsURI("http://localhost/gh/r;t=6", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=");
        UriBuilderImplTest.assertEqualsURI("http://localhost/gh/r;t=", this.uriBuilder);
        this.uriBuilder.replacePath("gh").path("r;t=6;g");
        UriBuilderImplTest.assertEqualsURI("http://localhost/gh/r;t=6;g", this.uriBuilder);
    }

    public void testReplaceQueryParams() throws Exception {
        this.uriBuilder.queryParam("a", new Object[]{"b"});
        this.uriBuilder.queryParam("c", new Object[]{"d"});
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2?a=b&c=d", this.uriBuilder);
        this.uriBuilder.replaceQuery("ksd hflk");
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2?ksd+hflk", this.uriBuilder);
        this.uriBuilder.replaceQuery("e=f");
        UriBuilderImplTest.assertEqualsURI("http://localhost/path1/path2?e=f", this.uriBuilder);
    }

    public void testScheme() throws Exception {
        this.uriBuilder.scheme("ftp");
        UriBuilderImplTest.assertEqualsURI("ftp://localhost/path1/path2", this.uriBuilder);
        this.uriBuilder.scheme("f4.-+tp");
        UriBuilderImplTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
        try {
            this.uriBuilder.scheme("44");
            UriBuilderImplTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        UriBuilderImplTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
        try {
            this.uriBuilder.scheme("f\u0000");
            UriBuilderImplTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        UriBuilderImplTest.assertEqualsURI("f4.-+tp://localhost/path1/path2", this.uriBuilder);
    }

    public void testSchemeSpecificPart() throws Exception {
        this.uriBuilder.schemeSpecificPart("//shkf");
        this.uriBuilder.replacePath("");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "shkf", null, "", null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//shkf-host/akfshdf");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "shkf-host", null, "/akfshdf", null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//user@shkf/akfshdf/akjhf");
        UriBuilderImplTest.assertEqualUriBuilder("http", "user", "shkf", null, "/akfshdf/akjhf", null, this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//shkf:4711/akjhf?a=b");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "shkf", "4711", "/akjhf", "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/akjhf;1=2?a=b");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "www.domain.org", null, "/akjhf;1=2", "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/akjhf;1=2;3=4?a=b");
        UriBuilderImplTest.assertEqualUriBuilder("http", null, "www.domain.org", null, "/akjhf;1=2;3=4", "a=b", this.uriBuilder, true);
        this.uriBuilder.schemeSpecificPart("//www.domain.org/ ");
        UriBuilderImplTest.assertEquals((String)"http://www.domain.org/%20", (String)this.uriBuilder.build(new Object[0]).toString());
    }

    public void testStaticFromPath() throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"path");
        if (uriBuilder instanceof UriBuilderImpl) {
            UriBuilderImplTest.assertEqualUriBuilder(null, null, null, null, "path", null, uriBuilder, true);
        }
        UriBuilderImplTest.assertEqualsURI("path", uriBuilder);
        uriBuilder = UriBuilder.fromPath((String)"path1/path2/abc.html");
        if (uriBuilder instanceof UriBuilderImpl) {
            UriBuilderImplTest.assertEqualUriBuilder(null, null, null, null, "path1/path2/abc.html", null, uriBuilder, true);
        }
        UriBuilderImplTest.assertEqualsURI("path1/path2/abc.html", uriBuilder);
        uriBuilder = UriBuilder.fromPath((String)"path1/path2;mp1=mv 1;mp2=mv2/abc.html");
        if (uriBuilder instanceof UriBuilderImpl) {
            UriBuilderImplTest.assertEqualUriBuilder(null, null, null, null, "path1/path2;mp1=mv%201;mp2=mv2/abc.html", null, uriBuilder, false);
        }
        UriBuilderImplTest.assertEquals((String)"path1/path2;mp1=mv%201;mp2=mv2/abc.html", (String)uriBuilder.build(new Object[0]).toString());
        String path = "path1/path2;mp1=mv1" + Reference.encode((String)"?") + ";mp2=mv2/abc.html";
        uriBuilder = UriBuilder.fromPath((String)path);
        if (uriBuilder instanceof UriBuilderImpl) {
            UriBuilderImplTest.assertEqualUriBuilder(null, null, null, null, "path1/path2;mp1=mv1%3F;mp2=mv2/abc.html", null, uriBuilder, false);
        }
    }

    public void testTemplateParams() throws Exception {
        this.changeWithTemplVars((UriBuilderImpl)this.uriBuilderWithVars);
        URI uri = this.buildFromTemplVarsWithMap(this.uriBuilderWithVars);
        UriBuilderImplTest.assertEqualsURI(TEMPL_VARS_EXPECTED, uri);
        uri = this.buildFromTemplVarsWithStrings(this.uriBuilderWithVars);
        UriBuilderImplTest.assertEqualsURI(TEMPL_VARS_EXPECTED, uri);
    }

    public void testToString() {
        UriBuilderImplTest.assertEquals((String)"http://localhost/path1/path2", (String)this.uriBuilder.toString());
    }

    public void testUri() throws Exception {
        URI u = new URI("ftp", "test.org", null, null, "fragment");
        this.uriBuilder.uri(u);
        UriBuilderImplTest.assertEqualsURI("ftp://test.org/#fragment", this.uriBuilder);
        u = new URI("ftp", "test.org", "/path", "qu=ery", "fragment");
        this.uriBuilder.uri(u);
        UriBuilderImplTest.assertEqualsURI("ftp://test.org/path?qu=ery#fragment", this.uriBuilder);
        String id = "4711";
        URI collectionUri = new URI("http://localhost:8181/SecurityContextTestService");
        URI location = UriBuilder.fromUri((URI)collectionUri).path("{id}").build(new Object[]{"4711"});
        UriBuilderImplTest.assertEqualsURI(collectionUri + "/4711", location);
    }

    public void testUserInfo() throws Exception {
        this.uriBuilder.userInfo("username");
        UriBuilderImplTest.assertEqualsURI("http://username@localhost/path1/path2", this.uriBuilder);
        this.uriBuilder.replacePath((String)null);
        this.uriBuilder.host("abc");
        this.uriBuilder.userInfo("username:pw");
        UriBuilderImplTest.assertEqualsUriSlashAllowed("http://username:pw@abc", this.uriBuilder);
        this.uriBuilder.userInfo("rkj;s78:&=+$,");
        UriBuilderImplTest.assertEqualsUriSlashAllowed("http://rkj;s78:&=+$,@abc", this.uriBuilder);
        this.uriBuilder.userInfo(" ");
        UriBuilderImplTest.assertEqualsUriSlashAllowed("http://%20@abc", this.uriBuilder);
    }

    static {
        try {
            URI_1 = new URI("http://localhost/path1/path2");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not initialize JaxRsUriBuilderTest");
        }
    }
}

