/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import junit.framework.AssertionFailedError;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.AppPlusXmlResource;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class AppPlusXmlTest
extends JaxRsTestCase {
    private static final MediaType APP_PERSON_XML = new MediaType("application/Person+xml");

    private void getAndCheck(MediaType mt) {
        Response response = this.get(mt);
        AppPlusXmlTest.sysOutEntityIfError(response);
        AppPlusXmlTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MediaType mediaType = response.getEntity().getMediaType();
        AppPlusXmlTest.assertEqualMediaType(mt, mediaType);
    }

    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(AppPlusXmlResource.class);
            }
        };
    }

    public void testGet() throws Exception {
        Response response = this.get();
        AppPlusXmlTest.sysOutEntityIfError(response);
        AppPlusXmlTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MediaType mediaType = response.getEntity().getMediaType();
        try {
            AppPlusXmlTest.assertEqualMediaType(MediaType.TEXT_XML, mediaType);
        }
        catch (AssertionFailedError afe) {
            try {
                AppPlusXmlTest.assertEqualMediaType(MediaType.APPLICATION_XML, mediaType);
            }
            catch (AssertionFailedError afe2) {
                AppPlusXmlTest.assertEqualMediaType(APP_PERSON_XML, mediaType);
            }
        }
    }

    public void testGet2() throws Exception {
        this.getAndCheck(MediaType.TEXT_XML);
        this.getAndCheck(MediaType.APPLICATION_XML);
        this.getAndCheck(APP_PERSON_XML);
    }
}

