/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.jaxrs.services.resources.SimpleTrain;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.jaxrs.util.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTrainTest
extends JaxRsTestCase {
    private static final boolean ONLY_M2 = false;
    private static final boolean ONLY_TEXT_ALL = false;
    private static final Preference<MediaType> PREF_TEXTPLAIN_QUAL05 = new Preference((Metadata)MediaType.TEXT_PLAIN, 0.5f);

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(SimpleTrain.class);
            }
        };
    }

    public void testGetHtmlText() throws Exception {
        Response response = this.get(MediaType.TEXT_HTML);
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertTrue((boolean)response.getStatus().isSuccess());
        Representation entity = response.getEntity();
        SimpleTrainTest.assertEquals((String)"<html><body>This is a simple html train</body></html>", (String)entity.getText());
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_HTML, entity.getMediaType());
    }

    public void testGetPlainText() throws Exception {
        Response response = this.get(MediaType.TEXT_PLAIN);
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        SimpleTrainTest.assertEquals((String)"This is a simple text train", (String)entity.getText());
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
    }

    public void testGetTextAll() throws Exception {
        Response response = this.get(MediaType.TEXT_ALL);
        SimpleTrainTest.sysOutEntityIfError(response);
        Representation representation = response.getEntity();
        MediaType mediaType = representation.getMediaType();
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertTrue((mediaType.equals((Object)MediaType.TEXT_PLAIN, true) || mediaType.equals((Object)MediaType.TEXT_HTML, true) ? 1 : 0) != 0);
        response = this.get(MediaType.TEXT_PLAIN);
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertTrue((boolean)response.getStatus().isSuccess());
        representation = response.getEntity();
        SimpleTrainTest.assertEquals((String)"This is a simple text train", (String)representation.getText());
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_PLAIN, representation);
    }

    public void testGetTextMultiple1() throws Exception {
        Response response = this.accessServer(Method.GET, SimpleTrain.class, TestUtils.createList(PREF_TEXTPLAIN_QUAL05, MediaType.TEXT_CALENDAR));
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        SimpleTrainTest.assertEquals((String)"This is a simple text train", (String)entity.getText());
    }

    public void testGetTextMultiple2() throws Exception {
        Response response = this.accessServer(Method.GET, SimpleTrain.class, TestUtils.createList(PREF_TEXTPLAIN_QUAL05, MediaType.TEXT_HTML));
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation representation = response.getEntity();
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_HTML, representation.getMediaType());
        SimpleTrainTest.assertEquals((String)"<html><body>This is a simple html train</body></html>", (String)representation.getText());
    }

    public void testHead() throws Exception {
        Response responseHead = this.accessServer(Method.HEAD, SimpleTrain.class, TestUtils.createList(PREF_TEXTPLAIN_QUAL05, MediaType.TEXT_HTML));
        Response responseGett = this.accessServer(Method.GET, SimpleTrain.class, TestUtils.createList(PREF_TEXTPLAIN_QUAL05, MediaType.TEXT_HTML));
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseHead.getStatus());
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseGett.getStatus());
        Representation entityHead = responseHead.getEntity();
        Representation entityGett = responseGett.getEntity();
        SimpleTrainTest.assertNotNull((Object)entityHead);
        SimpleTrainTest.assertNotNull((Object)entityGett);
        SimpleTrainTest.assertEqualMediaType(MediaType.TEXT_HTML, entityGett.getMediaType());
        SimpleTrainTest.assertEquals((String)"<html><body>This is a simple html train</body></html>", (String)entityGett.getText());
    }

    public void testOptions() throws Exception {
        Response response = this.options();
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertAllowedMethod(response, Method.GET);
    }

    public void testTemplParamsDecoded() throws Exception {
        String deEncoded = "decode";
        Response response = this.get("decode/66");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"66", (String)response.getEntity().getText());
        response = this.get("decode/a+bc");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"a bc", (String)response.getEntity().getText());
        response = this.get("decode/a%20bc");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"a bc", (String)response.getEntity().getText());
    }

    public void testTemplParamsEncoded() throws Exception {
        String deEncoded = "encode";
        Response response = this.get("encode/66");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"66", (String)response.getEntity().getText());
        response = this.get("encode/a+bc");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"a+bc", (String)response.getEntity().getText());
        response = this.get("encode/a%20bc");
        SimpleTrainTest.sysOutEntityIfError(response);
        SimpleTrainTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        SimpleTrainTest.assertEquals((String)"a%20bc", (String)response.getEntity().getText());
    }

    public void testUseAllTests() {
        SimpleTrainTest.assertFalse((String)"You should use all tests", (boolean)false);
        SimpleTrainTest.assertFalse((String)"You should use all tests", (boolean)false);
    }

    protected Class<?> getRootResourceClass() {
        throw new UnsupportedOperationException("You must implement the methods getRootResourceClass() or getAppConfig(). If you only implemented getAppConfig(), you can't use this method");
    }
}

