/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import org.restlet.data.AuthenticationInfo;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.test.RestletTestCase;

public class AuthenticationInfoTestCase
extends RestletTestCase {
    public void testAuthenticaitonInfoHeaderParse() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("00000002", 1, "MDAzMTAw1", "auth", null);
        String authInfoHeader = new String("nc=00000001, qop=auth, cnonce=\"MDAzMTAw1\", nextnonce=00000002");
        AuthenticationInfo parsedAuthInfo = AuthenticatorUtils.parseAuthenticationInfo((String)authInfoHeader);
        AuthenticationInfoTestCase.assertTrue((boolean)authInfo.equals((Object)parsedAuthInfo));
        AuthenticationInfoTestCase.assertTrue((boolean)parsedAuthInfo.equals((Object)authInfo));
    }

    public void testCnonce() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getClientNonce(), (String)"testcnonce");
        String newCnonce = new String("newcnonce");
        authInfo.setClientNonce(newCnonce);
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getClientNonce(), (String)"newcnonce");
    }

    public void testEquals() throws Exception {
        AuthenticationInfo authInfo1 = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfo authInfo2 = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((Object)authInfo1, (Object)authInfo2);
        AuthenticationInfoTestCase.assertTrue((boolean)authInfo1.equals((Object)authInfo2));
    }

    public void testNextNonce() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getNextServerNonce(), (String)"testnonce");
        String newNonce = new String("newnonce");
        authInfo.setNextServerNonce(newNonce);
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getNextServerNonce(), (String)"newnonce");
    }

    public void testNonceCount() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((int)authInfo.getNonceCount(), (int)1111111);
        int newNonceCount = 2222222;
        authInfo.setNonceCount(newNonceCount);
        AuthenticationInfoTestCase.assertEquals((int)authInfo.getNonceCount(), (int)2222222);
    }

    public void testQop() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getQuality(), (String)"auth");
        String newQop = new String("auth-int");
        authInfo.setQuality(newQop);
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getQuality(), (String)"auth-int");
    }

    public void testResponseAuth() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo("testnonce", 1111111, "testcnonce", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getResponseDigest(), (String)"FFFFFF");
        String newResponseAuth = new String("000000");
        authInfo.setResponseDigest(newResponseAuth);
        AuthenticationInfoTestCase.assertEquals((String)authInfo.getResponseDigest(), (String)"000000");
    }

    public void testUnEquals() throws Exception {
        AuthenticationInfo authInfo1 = new AuthenticationInfo("testnonce1", 1111111, "testcnonce1", "auth", "FFFFFF");
        AuthenticationInfo authInfo2 = new AuthenticationInfo("testnonce2", 1111111, "testcnonce2", "auth", "FFFFFF");
        AuthenticationInfoTestCase.assertFalse((boolean)authInfo1.equals((Object)authInfo2));
        AuthenticationInfoTestCase.assertFalse((boolean)authInfo1.equals(null));
        AuthenticationInfoTestCase.assertFalse((boolean)authInfo2.equals(null));
        AuthenticationInfoTestCase.assertFalse((boolean)authInfo1.getNextServerNonce().equals(authInfo2.getNextServerNonce()));
        AuthenticationInfoTestCase.assertFalse((boolean)authInfo1.getClientNonce().equals(authInfo2.getClientNonce()));
    }
}

