/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.car;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.restlet.test.jaxrs.services.car.CarResource;

@Path(value="cars")
public class CarListResource {
    public static final String DUMMY_CAR_LIST = "[1, 2, 5]";
    public static final String OFFERS = "This are test offers";
    public static final String PATH = "cars";
    public static final String OFFERS_PATH = "offers";

    @Path(value="{id}")
    @Encoded
    public CarResource findCar(@PathParam(value="id") int id) {
        return new CarResource(id);
    }

    @GET
    @Produces(value={"text/plain"})
    public String getCarList() {
        return DUMMY_CAR_LIST;
    }

    @GET
    @Path(value="offers")
    @Produces(value={"text/plain"})
    public String getOffers() throws WebApplicationException {
        return OFFERS;
    }

    @POST
    public Response newCar(@Context UriInfo uriInfo) {
        int newId = 47;
        URI newUri = uriInfo.getAbsolutePathBuilder().path("{id}").build(new Object[]{47});
        return Response.created((URI)newUri).build();
    }

    @POST
    @Path(value="offers")
    public Response newCarOffer() {
        try {
            return Response.created((URI)new URI("../5")).build();
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

