/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ResourceException;
import org.restlet.test.RestletTestCase;
import org.restlet.test.resource.MyResource8;

public class AnnotatedResource8TestCase
extends RestletTestCase {
    private ClientResource clientResource;

    protected void setUp() throws Exception {
        super.setUp();
        Finder finder = new Finder();
        finder.setTargetClass(MyResource8.class);
        this.clientResource = new ClientResource("http://local");
        this.clientResource.setNext((Uniform)finder);
    }

    protected void tearDown() throws Exception {
        this.clientResource = null;
        super.tearDown();
    }

    public void testGet() throws IOException, ResourceException {
        StringRepresentation input = new StringRepresentation((CharSequence)"<root/>", MediaType.APPLICATION_XML);
        Representation result = this.clientResource.post((Object)input, MediaType.APPLICATION_XML);
        AnnotatedResource8TestCase.assertNotNull((Object)result);
        AnnotatedResource8TestCase.assertEquals((String)"<root/>1", (String)result.getText());
        AnnotatedResource8TestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)result.getMediaType());
        input = new StringRepresentation((CharSequence)"<root/>", MediaType.APPLICATION_XML);
        result = this.clientResource.post((Object)input, MediaType.APPLICATION_JSON);
        AnnotatedResource8TestCase.assertNotNull((Object)result);
        AnnotatedResource8TestCase.assertEquals((String)"<root/>2", (String)result.getText());
        AnnotatedResource8TestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)result.getMediaType());
        input = new StringRepresentation((CharSequence)"root=true", MediaType.APPLICATION_WWW_FORM);
        result = this.clientResource.post((Object)input, MediaType.APPLICATION_JSON);
        AnnotatedResource8TestCase.assertNotNull((Object)result);
        AnnotatedResource8TestCase.assertEquals((String)"root=true3", (String)result.getText());
        AnnotatedResource8TestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)result.getMediaType());
        Form inputForm = new Form();
        inputForm.add("root", "true");
        result = this.clientResource.post((Object)inputForm, MediaType.APPLICATION_JSON);
        AnnotatedResource8TestCase.assertNotNull((Object)result);
        AnnotatedResource8TestCase.assertEquals((String)"root=true3", (String)result.getText());
        AnnotatedResource8TestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)result.getMediaType());
        input = new StringRepresentation((CharSequence)"[root]", MediaType.APPLICATION_JSON);
        result = this.clientResource.post((Object)input, MediaType.APPLICATION_JSON);
        AnnotatedResource8TestCase.assertNotNull((Object)result);
        AnnotatedResource8TestCase.assertEquals((String)"[root]2", (String)result.getText());
        AnnotatedResource8TestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)result.getMediaType());
    }
}

