/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.security;

import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.security.Group;
import org.restlet.security.MemoryRealm;
import org.restlet.security.User;
import org.restlet.test.RestletTestCase;
import org.restlet.test.security.SaasApplication;

public class SaasComponent
extends Component {
    public SaasComponent() {
        Context context = this.getContext().createChildContext();
        SaasApplication app = new SaasApplication(context);
        MemoryRealm realm = new MemoryRealm();
        context.setDefaultEnroler(realm.getEnroler());
        context.setDefaultVerifier(realm.getVerifier());
        User stiger = new User("stiger", "pwd", "Scott", "Tiger", "scott.tiger@foobar.com");
        realm.getUsers().add(stiger);
        User larmstrong = new User("larmstrong", "pwd", "Louis", "Armstrong", "la@foobar.com");
        realm.getUsers().add(larmstrong);
        Group employees = new Group("employees ", "All FooBar employees");
        employees.getMemberUsers().add(larmstrong);
        realm.getRootGroups().add(employees);
        Group contractors = new Group("contractors ", "All FooBar contractors");
        contractors.getMemberUsers().add(stiger);
        realm.getRootGroups().add(contractors);
        Group managers = new Group("managers", "All FooBar managers");
        realm.getRootGroups().add(managers);
        Group directors = new Group("directors ", "Top-level directors");
        directors.getMemberUsers().add(larmstrong);
        managers.getMemberGroups().add(directors);
        Group developers = new Group("developers", "All FooBar developers");
        realm.getRootGroups().add(developers);
        Group engineers = new Group("engineers", "All FooBar engineers");
        engineers.getMemberUsers().add(stiger);
        developers.getMemberGroups().add(engineers);
        realm.map(managers, app.getRole("admin"));
        this.getDefaultHost().attach((Restlet)app);
        this.getServers().add(Protocol.HTTP, RestletTestCase.TEST_PORT);
    }
}

