/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.component;

import java.util.List;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;
import org.restlet.service.LogService;
import org.restlet.test.RestletTestCase;
import org.restlet.util.ClientList;
import org.restlet.util.ServerList;

public class ComponentXmlConfigTestCase
extends RestletTestCase {
    private static final String A_PARAM_NAME = "attachParamName";
    private static final String A_PARAM_VALUE = "attachParamValue";
    private static final String ATTACH = "ATTACH";
    private static final String C_NAME = "componentParamName";
    private static final String C_VALUE = "componentParamValue";
    private static final String CLIENT = "CLIENT";
    private static final String COMPONENT = "COMPONENT";
    private static final String CON_PARAM_NAME = "connectorParamName";
    private static final String CON_PARAM_VALUE = "connectorParamValue";
    private static final String HOST = "HOST";
    private static final boolean LOG_ENABLED = false;
    private static final String LOG_FORMAT = "logFormat";
    private static final boolean LOG_IDENTITY_CHECKED = true;
    private static final String LOGGER_NAME = "loggerName";
    private static final int PORT1 = TEST_PORT;
    private static final int PORT2 = PORT1 + 1;
    private static final String R_NAME = "routerParamName";
    private static final String R_VALUE = "routerParamValue";
    private static final String RESTLET_DESCRIPTION = "restletDescription";
    private static final String RESTLET_NAME = "restletName";
    private static final String RESTLET_XML = "<?xml version=\"1.0\"?>\n<component xmlns=\"http://www.restlet.org/schemas/2.0/Component\">\n<client protocol=\"HTTP\" name=\"restletName\" description=\"restletDescription\">\n<parameter name=\"connectorParamName3\" value=\"connectorParamValue3\"/>\n<parameter name=\"connectorParamName4\" value=\"connectorParamValue4\"/>\n</client>\n<illegal-element name=\"componentParamName1\" value=\"componentParamValue1\"/>\n<server  name=\"restletName\" description=\"restletDescription\" protocol=\"HTTP\" port=\"" + PORT1 + "\">\n" + "<parameter name=\"" + "connectorParamName" + "1\" value=\"" + "connectorParamValue" + "1\"/>\n" + "<parameter name=\"" + "connectorParamName" + "2\" value=\"" + "connectorParamValue" + "2\"/>\n" + "</server>\n" + "<parameter name=\"" + "componentParamName" + "1\" value=\"" + "componentParamValue" + "1\"/>\n" + "<parameter name=\"" + "componentParamName" + "2\" value=\"" + "componentParamValue" + "2\"/>\n" + "<defaultHost " + " name=\"" + "restletName" + "\"" + " description=\"" + "restletDescription" + "\" hostPort=\"" + PORT1 + "\">\n" + "<parameter name=\"" + "routerParamName" + "1\" value=\"" + "routerParamValue" + "1\"/>\n" + "<parameter name=\"" + "routerParamName" + "2\" value=\"" + "routerParamValue" + "2\"/>\n" + "<attach uriPattern=\"/abcd\" targetClass=\"org.restlet.test.component.HelloWorldApplication\">\n" + "<parameter name=\"" + "attachParamName" + "1\" value=\"" + "attachParamValue" + "1\"/>\n" + "<parameter name=\"" + "attachParamName" + "2\" value=\"" + "attachParamValue" + "2\"/>\n" + "</attach>\n" + "<attach uriPattern=\"/foo\" targetClass=\"org.restlet.test.component.HelloWorldApplication\">\n" + "<parameter name=\"" + "attachParamName" + "3\" value=\"" + "attachParamValue" + "3\"/>\n" + "<parameter name=\"" + "attachParamName" + "4\" value=\"" + "attachParamValue" + "4\"/>\n" + "</attach>\n" + "</defaultHost>\n" + "<host hostPort=\"" + PORT2 + "\">\n" + "<parameter name=\"" + "routerParamName" + "3\" value=\"" + "routerParamValue" + "3\"/>\n" + "<parameter name=\"" + "routerParamName" + "4\" value=\"" + "routerParamValue" + "4\"/>\n" + "<attach uriPattern=\"/efgh\" targetClass=\"org.restlet.test.component.HelloWorldApplication\">\n" + "<parameter name=\"" + "attachParamName" + "5\" value=\"" + "attachParamValue" + "5\"/>\n" + "<parameter name=\"" + "attachParamName" + "6\" value=\"" + "attachParamValue" + "6\"/>\n" + "</attach>\n" + "</host>\n" + "<logService enabled=\"" + false + "\" identityCheck=\"" + true + "\" logFormat=\"" + "logFormat" + "\" loggerName=\"" + "loggerName" + "\" />\n" + "</component>";
    private static final String SERVER = "SERVER";
    private Component c;

    private void checkNegativeParam(String msg, Context ctx, String n) {
        Parameter p = (Parameter)ctx.getParameters().getFirst(n);
        ComponentXmlConfigTestCase.assertNull((String)(msg + " Parameter '" + n + "' MUST be null"), (Object)p);
    }

    private void checkPositiveParam(String msg, Context ctx, String n, String v) {
        ComponentXmlConfigTestCase.assertNotNull((String)(msg + "Context MUST NOT be null"), (Object)ctx);
        Parameter p = (Parameter)ctx.getParameters().getFirst(n);
        ComponentXmlConfigTestCase.assertNotNull((String)(msg + "Parameter '" + n + "' MUST NOT be null"), (Object)p);
        String pValue = p.getValue();
        ComponentXmlConfigTestCase.assertNotNull((String)(msg + "Parameter '" + n + "' MUST NOT have a null value"), (Object)pValue);
        ComponentXmlConfigTestCase.assertEquals((String)(msg + "Parameter '" + n + "' has unexpected value"), (String)v, (String)pValue);
    }

    protected void setUp() throws Exception {
        super.setUp();
        StringRepresentation xml = new StringRepresentation((CharSequence)RESTLET_XML);
        this.c = new Component((Representation)xml);
        ComponentXmlConfigTestCase.assertNotNull((String)"Component (parsed) MUST NOT be null", (Object)this.c);
    }

    protected void tearDown() throws Exception {
        this.c.stop();
        this.c = null;
        super.tearDown();
    }

    public void testAttachParams1a() throws Exception {
        System.out.println("-- testAttachParams1a()");
        TemplateRoute route = (TemplateRoute)this.c.getDefaultHost().getRoutes().get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The first Attach element of the Default Host MUST NOT be null", (Object)route);
        String msg = "[ATTACH #1] ";
        Context ctx = route.getNext().getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkPositiveParam(msg, ctx, "attachParamName1", "attachParamValue1");
        this.checkPositiveParam(msg, ctx, "attachParamName2", "attachParamValue2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testAttachParams1b() throws Exception {
        System.out.println("-- testAttachParams1b()");
        TemplateRoute route = (TemplateRoute)this.c.getDefaultHost().getRoutes().get(1);
        ComponentXmlConfigTestCase.assertNotNull((String)"The second Attach element of the Default Host MUST NOT be null", (Object)route);
        String msg = "[ATTACH #2] ";
        Context ctx = route.getNext().getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkPositiveParam(msg, ctx, "attachParamName3", "attachParamValue3");
        this.checkPositiveParam(msg, ctx, "attachParamName4", "attachParamValue4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testAttachParams2() throws Exception {
        System.out.println("-- testAttachParams2()");
        TemplateRoute route = (TemplateRoute)((VirtualHost)this.c.getHosts().get(0)).getRoutes().get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Attach element of the Single Host MUST NOT be null", (Object)route);
        String msg = "[ATTACH] ";
        Context ctx = route.getNext().getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkPositiveParam(msg, ctx, "attachParamName5", "attachParamValue5");
        this.checkPositiveParam(msg, ctx, "attachParamName6", "attachParamValue6");
    }

    public void testClient() throws Exception {
        System.out.println("-- testClient()");
        ClientList clients = this.c.getClients();
        ComponentXmlConfigTestCase.assertNotNull((String)"Client list MUST NOT be null", (Object)clients);
        ComponentXmlConfigTestCase.assertEquals((String)"Client list MUST contain 1 item", (int)1, (int)clients.size());
        Client client = (Client)clients.get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Client MUST NOT be null", (Object)client);
        ComponentXmlConfigTestCase.assertEquals((String)client.getName(), (String)RESTLET_NAME);
        ComponentXmlConfigTestCase.assertEquals((String)client.getDescription(), (String)RESTLET_DESCRIPTION);
    }

    public void testClientParams() throws Exception {
        System.out.println("-- testClientParams()");
        ClientList clients = this.c.getClients();
        ComponentXmlConfigTestCase.assertNotNull((String)"Client list MUST NOT be null", (Object)clients);
        ComponentXmlConfigTestCase.assertEquals((String)"Client list MUST contain 1 item", (int)1, (int)clients.size());
        Client client = (Client)clients.get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Client MUST NOT be null", (Object)client);
        String msg = "[CLIENT] ";
        Context ctx = client.getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkPositiveParam(msg, ctx, "connectorParamName3", "connectorParamValue3");
        this.checkPositiveParam(msg, ctx, "connectorParamName4", "connectorParamValue4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testComponentParams() throws Exception {
        System.out.println("-- testComponentParams()");
        String msg = "[COMPONENT] ";
        Context ctx = this.c.getContext();
        this.checkPositiveParam(msg, ctx, "componentParamName1", "componentParamValue1");
        this.checkPositiveParam(msg, ctx, "componentParamName2", "componentParamValue2");
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testDefaultHost() throws Exception {
        System.out.println("-- testDefaultHost()");
        VirtualHost dh = this.c.getDefaultHost();
        ComponentXmlConfigTestCase.assertNotNull((String)"Default Host MUST NOT be null", (Object)dh);
        ComponentXmlConfigTestCase.assertEquals((String)dh.getName(), (String)RESTLET_NAME);
        ComponentXmlConfigTestCase.assertEquals((String)dh.getDescription(), (String)RESTLET_DESCRIPTION);
    }

    public void testDefaultHostParams() throws Exception {
        System.out.println("-- testDefaultHostParams()");
        VirtualHost dh = this.c.getDefaultHost();
        ComponentXmlConfigTestCase.assertNotNull((String)"Default Host MUST NOT be null", (Object)dh);
        String msg = "[HOST:" + dh.getHostPort() + "] ";
        Context ctx = dh.getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkPositiveParam(msg, ctx, "routerParamName1", "routerParamValue1");
        this.checkPositiveParam(msg, ctx, "routerParamName2", "routerParamValue2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testHostParams() throws Exception {
        System.out.println("-- testHostParams()");
        List hosts = this.c.getHosts();
        ComponentXmlConfigTestCase.assertNotNull((String)"Host List MUST NOT be null", (Object)hosts);
        ComponentXmlConfigTestCase.assertEquals((String)"Server list MUST contain 1 item", (int)1, (int)hosts.size());
        VirtualHost host = (VirtualHost)hosts.get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Host MUST NOT be null", (Object)host);
        String msg = "[HOST:" + host.getHostPort() + "] ";
        Context ctx = host.getContext();
        this.checkNegativeParam(msg, ctx, "connectorParamName1");
        this.checkNegativeParam(msg, ctx, "connectorParamName2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkPositiveParam(msg, ctx, "routerParamName3", "routerParamValue3");
        this.checkPositiveParam(msg, ctx, "routerParamName4", "routerParamValue4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }

    public void testLogService() throws Exception {
        System.out.println("-- testLogService()");
        LogService ls = this.c.getLogService();
        ComponentXmlConfigTestCase.assertNotNull((String)"Log service MUST NOT be null", (Object)ls);
        ComponentXmlConfigTestCase.assertEquals((boolean)false, (boolean)ls.isEnabled());
        ComponentXmlConfigTestCase.assertEquals((boolean)true, (boolean)ls.isIdentityCheck());
        ComponentXmlConfigTestCase.assertEquals((String)LOG_FORMAT, (String)ls.getResponseLogFormat());
        ComponentXmlConfigTestCase.assertEquals((String)LOGGER_NAME, (String)ls.getLoggerName());
    }

    public void testServer() throws Exception {
        System.out.println("-- testServerParams()");
        ServerList servers = this.c.getServers();
        ComponentXmlConfigTestCase.assertNotNull((String)"Server list MUST NOT be null", (Object)servers);
        ComponentXmlConfigTestCase.assertEquals((String)"Server list MUST contain 1 item", (int)1, (int)servers.size());
        Server server = (Server)servers.get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Server MUST NOT be null", (Object)server);
        ComponentXmlConfigTestCase.assertEquals((String)server.getName(), (String)RESTLET_NAME);
        ComponentXmlConfigTestCase.assertEquals((String)server.getDescription(), (String)RESTLET_DESCRIPTION);
    }

    public void testServerParams() throws Exception {
        System.out.println("-- testServerParams()");
        ServerList servers = this.c.getServers();
        ComponentXmlConfigTestCase.assertNotNull((String)"Server list MUST NOT be null", (Object)servers);
        ComponentXmlConfigTestCase.assertEquals((String)"Server list MUST contain 1 item", (int)1, (int)servers.size());
        Server server = (Server)servers.get(0);
        ComponentXmlConfigTestCase.assertNotNull((String)"The single Server MUST NOT be null", (Object)server);
        String msg = "[SERVER] ";
        Context ctx = server.getContext();
        this.checkPositiveParam(msg, ctx, "connectorParamName1", "connectorParamValue1");
        this.checkPositiveParam(msg, ctx, "connectorParamName2", "connectorParamValue2");
        this.checkNegativeParam(msg, ctx, "connectorParamName3");
        this.checkNegativeParam(msg, ctx, "connectorParamName4");
        this.checkNegativeParam(msg, ctx, "componentParamName1");
        this.checkNegativeParam(msg, ctx, "componentParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName1");
        this.checkNegativeParam(msg, ctx, "routerParamName2");
        this.checkNegativeParam(msg, ctx, "routerParamName3");
        this.checkNegativeParam(msg, ctx, "routerParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName1");
        this.checkNegativeParam(msg, ctx, "attachParamName2");
        this.checkNegativeParam(msg, ctx, "attachParamName3");
        this.checkNegativeParam(msg, ctx, "attachParamName4");
        this.checkNegativeParam(msg, ctx, "attachParamName5");
        this.checkNegativeParam(msg, ctx, "attachParamName6");
    }
}

