/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.util;

import java.util.Locale;
import junit.framework.TestCase;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.util.Series;

public class ConverterTests
extends TestCase {
    private void checkToLanguageToLocale(Locale locale) {
        ConverterTests.assertEquals((Object)locale, (Object)Converter.toLocale((Language)Converter.toLanguage((Locale)locale)));
    }

    public void testGetMediaTypeWitoutParams1() {
        ConverterTests.assertEquals(null, (Object)Converter.getMediaTypeWithoutParams((MediaType)null));
        ConverterTests.assertEquals((Object)MediaType.TEXT_HTML, (Object)Converter.getMediaTypeWithoutParams((MediaType)MediaType.TEXT_HTML));
    }

    public void testGetMediaTypeWitoutParams2() {
        Series params = new Series(Parameter.class);
        params.add("abc", "def");
        MediaType mt = new MediaType("a/b", params);
        ConverterTests.assertEquals((String)"a/b", (String)Converter.getMediaTypeWithoutParams((MediaType)mt).toString());
    }

    public void testToLanguageToLocale() {
        this.checkToLanguageToLocale(Locale.CANADA);
        this.checkToLanguageToLocale(Locale.CANADA_FRENCH);
        this.checkToLanguageToLocale(Locale.CHINA);
        this.checkToLanguageToLocale(Locale.CHINESE);
        this.checkToLanguageToLocale(Locale.ENGLISH);
        this.checkToLanguageToLocale(Locale.FRANCE);
        this.checkToLanguageToLocale(Locale.FRENCH);
        this.checkToLanguageToLocale(Locale.GERMAN);
        this.checkToLanguageToLocale(Locale.GERMANY);
        this.checkToLanguageToLocale(Locale.ITALIAN);
        this.checkToLanguageToLocale(Locale.ITALY);
        this.checkToLanguageToLocale(Locale.JAPAN);
        this.checkToLanguageToLocale(Locale.JAPANESE);
        this.checkToLanguageToLocale(Locale.KOREA);
        this.checkToLanguageToLocale(Locale.KOREAN);
        this.checkToLanguageToLocale(Locale.PRC);
        this.checkToLanguageToLocale(Locale.SIMPLIFIED_CHINESE);
        this.checkToLanguageToLocale(Locale.TAIWAN);
        this.checkToLanguageToLocale(Locale.TRADITIONAL_CHINESE);
        this.checkToLanguageToLocale(Locale.UK);
        this.checkToLanguageToLocale(Locale.US);
    }

    public void testToLocale() {
        ConverterTests.assertEquals((Object)new Locale("abc"), (Object)Converter.toLocale((String)"abc"));
        ConverterTests.assertEquals((Object)new Locale("abc", "", "def"), (Object)Converter.toLocale((String)"abc__def"));
        ConverterTests.assertEquals((Object)new Locale("abc", "def"), (Object)Converter.toLocale((String)"abc_def"));
    }
}

