/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import org.restlet.ext.jaxrs.internal.util.EncodeOrCheck;
import org.restlet.test.RestletTestCase;

public class EncodeOrCheckTests
extends RestletTestCase {
    static final Method FRAGMENT;
    static final Method FULL_MATRIX;
    static final Method FULL_QUERY;
    static final Method HOST;
    static final Method NAME_OR_VALUE;
    static final Method PATH_SEGMENT_WITH_MATRIX;
    static final Method PATH_WITHOUT_MATRIX;
    static final Method SCHEME;
    static final Method USER_INFO;

    private void check(Method method, String in, Boolean encode, String out) {
        try {
            Object result;
            int paramCount = method.getParameterTypes().length;
            if (paramCount == 0) {
                throw new AssertionFailedError("The method " + method + " must have between 1 and 3 parameters");
            }
            if (paramCount == 1) {
                result = method.invoke(null, in);
            } else if (paramCount == 2 && encode != null) {
                result = method.invoke(null, in, encode);
            } else if (paramCount == 3 && encode != null) {
                result = method.invoke(null, in, encode, "{generic test error message}");
            } else {
                throw new AssertionFailedError("The method " + method + " has to much parameters");
            }
            if (paramCount > 1) {
                if (out == null) {
                    EncodeOrCheckTests.fail((String)("must throw an IllegalArgumentException for \"" + in + "\" and encode = " + encode));
                }
                EncodeOrCheckTests.assertEquals((String)out, (String)(result != null ? result.toString() : null));
            }
        }
        catch (InvocationTargetException e) {
            if (!(e.getCause() instanceof IllegalArgumentException)) {
                throw (RuntimeException)e.getCause();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    void checkEncoding(Method method, String in, String encodedOut) {
        this.check(method, in, true, encodedOut);
        this.check(method, in, false, null);
    }

    void checkForInvalidCharFail(String uriPart) {
        try {
            EncodeOrCheck.checkForInvalidUriChars((CharSequence)uriPart, (int)-1, (String)"");
            EncodeOrCheckTests.fail((String)("\"" + uriPart + "\" contains an invalid char. The test must fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void checkInvalid(Method method, String in) {
        this.check(method, in, true, null);
        this.check(method, in, false, null);
    }

    void checkNoEncode(Method method, String testString) {
        this.check(method, testString, true, testString);
        this.check(method, testString, false, testString);
    }

    public void testCheckForInvalidUriChars() {
        String allowed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890{}";
        EncodeOrCheck.checkForInvalidUriChars((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890{}", (int)-1, (String)"");
        EncodeOrCheck.checkForInvalidUriChars((CharSequence)"aaaaa", (int)-1, (String)"");
        EncodeOrCheck.checkForInvalidUriChars((CharSequence)"\\\\\\", (int)-1, (String)"");
        this.checkForInvalidCharFail("a:a");
        this.checkForInvalidCharFail("a:1");
        this.checkForInvalidCharFail("/a:");
        this.checkForInvalidCharFail("a:");
        this.checkForInvalidCharFail("/");
        this.checkForInvalidCharFail(" ");
        this.checkForInvalidCharFail("\u0000");
        this.checkForInvalidCharFail("abc{ }kg jj");
        EncodeOrCheck.checkForInvalidUriChars((CharSequence)"abc{ }kgjj", (int)-1, (String)"test");
    }

    public void testEncodePathWithoutMatrix() {
        EncodeOrCheck.pathWithoutMatrix((CharSequence)"");
        EncodeOrCheck.pathWithoutMatrix((CharSequence)"%20");
    }

    public void testFragment() {
        this.checkNoEncode(FRAGMENT, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-._~");
        this.checkInvalid(FRAGMENT, "{}");
        this.checkNoEncode(FRAGMENT, "dfd{  %K}7");
        this.checkInvalid(FRAGMENT, "dfd{ { %K}}}7");
        this.checkInvalid(FRAGMENT, "dfd{}7");
    }

    public void testFullMatrixes() {
        this.xtestFullQueryOrMatrix(FULL_MATRIX, ';', '&');
        this.checkEncoding(FULL_MATRIX, "jhg jk", "jhg%20jk");
    }

    public void testFullQueries() {
        this.xtestFullQueryOrMatrix(FULL_QUERY, '&', ';');
        this.checkEncoding(FULL_QUERY, "jhg jk", "jhg+jk");
    }

    public void testHost() throws Exception {
        this.checkNoEncode(HOST, "a");
        this.checkNoEncode(HOST, "a{sdf}f");
        this.checkNoEncode(HOST, "a{   }f");
        this.checkEncoding(HOST, "a{   } f", "a{   }%20f");
        this.checkNoEncode(HOST, "98.76.54.32");
        this.checkNoEncode(HOST, "9876:fg12::5432");
    }

    public void testNameOrValue() {
        this.checkNoEncode(NAME_OR_VALUE, "");
        this.checkNoEncode(NAME_OR_VALUE, "sdf");
        EncodeOrCheckTests.assertEquals((String)"sdf%20hfdf", (String)EncodeOrCheck.nameOrValue((Object)"sdf%20hfdf", (boolean)false, (String)"guj"));
        EncodeOrCheckTests.assertEquals((String)"sdf%2520hfdf", (String)EncodeOrCheck.nameOrValue((Object)"sdf%20hfdf", (boolean)true, (String)"guj"));
        this.checkEncoding(NAME_OR_VALUE, "abc def", "abc%20def");
        StringBuilder reservedEnc = new StringBuilder();
        for (int i = 0; i < ":/?#[]@!$&'()*+,;=".length(); ++i) {
            EncodeOrCheck.toHex((char)":/?#[]@!$&'()*+,;=".charAt(i), (StringBuilder)reservedEnc);
        }
        this.checkEncoding(NAME_OR_VALUE, ":/?#[]@!$&'()*+,;=", reservedEnc.toString());
    }

    public void testPathSegmentWithMatrix() {
        this.checkNoEncode(PATH_SEGMENT_WITH_MATRIX, "");
        this.checkNoEncode(PATH_SEGMENT_WITH_MATRIX, "sdf");
        this.checkEncoding(PATH_SEGMENT_WITH_MATRIX, "abc def", "abc%20def");
        this.checkNoEncode(PATH_SEGMENT_WITH_MATRIX, "abc;1298=213");
    }

    public void testSchemeCheck() {
        EncodeOrCheck.scheme((String)"f");
    }

    public void testUserInfo() {
        this.checkNoEncode(USER_INFO, "");
        this.checkNoEncode(USER_INFO, "a");
        this.checkNoEncode(USER_INFO, "a{g}a");
        this.checkNoEncode(USER_INFO, "a{g }a");
        this.checkNoEncode(USER_INFO, "user:password");
        this.checkEncoding(USER_INFO, "a{g } a", "a{g }%20a");
    }

    private void xtestFullQueryOrMatrix(Method method, char delim, char nonDelim) {
        String nonDelimStr = nonDelim == ';' ? "%3B" : "%26";
        String str = "jshfk=kzi" + delim + "hk=" + delim + "k" + delim + delim;
        this.checkNoEncode(method, str);
        this.checkEncoding(method, str + nonDelim, str + nonDelimStr);
        this.checkNoEncode(method, "");
        this.checkEncoding(method, delim + "=" + nonDelim + "?", delim + "=" + nonDelimStr + "%3F");
        this.checkNoEncode(method, "{s&?df}");
        this.checkNoEncode(method, "{sdf}");
        this.checkNoEncode(method, delim + "{sdf}");
        this.checkInvalid(method, "gg{nk{}}");
        this.checkInvalid(method, "gg{nk{");
        this.checkInvalid(method, "gg}ff");
    }

    static {
        try {
            FRAGMENT = EncodeOrCheck.class.getMethod("fragment", CharSequence.class);
            FULL_MATRIX = EncodeOrCheck.class.getMethod("fullMatrix", CharSequence.class);
            FULL_QUERY = EncodeOrCheck.class.getMethod("fullQuery", CharSequence.class, Boolean.TYPE);
            HOST = EncodeOrCheck.class.getMethod("host", String.class);
            NAME_OR_VALUE = EncodeOrCheck.class.getMethod("nameOrValue", Object.class, Boolean.TYPE, String.class);
            PATH_SEGMENT_WITH_MATRIX = EncodeOrCheck.class.getMethod("pathSegmentWithMatrix", CharSequence.class, Boolean.TYPE);
            PATH_WITHOUT_MATRIX = EncodeOrCheck.class.getMethod("pathWithoutMatrix", CharSequence.class);
            SCHEME = EncodeOrCheck.class.getMethod("scheme", String.class);
            USER_INFO = EncodeOrCheck.class.getMethod("userInfo", CharSequence.class, Boolean.TYPE);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

