/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Router;
import org.restlet.test.RestletTestCase;
import org.restlet.test.resource.MyResource11;

public class AnnotatedResource11TestCase
extends RestletTestCase {
    private Component c;
    private Client client;
    private String uri;

    protected void setUp() throws Exception {
        super.setUp();
        Engine.getInstance().getRegisteredConverters().clear();
        Engine.getInstance().registerDefaultConverters();
        this.c = new Component();
        Server server = this.c.getServers().add(Protocol.HTTP, 0);
        this.c.getDefaultHost().attach((Restlet)new TestApplication());
        this.c.start();
        this.client = new Client(Protocol.HTTP);
        this.uri = "http://localhost:" + server.getEphemeralPort() + "/test";
    }

    protected void tearDown() throws Exception {
        this.c.stop();
        this.c = null;
        this.client.stop();
        this.client = null;
        super.tearDown();
    }

    public void test() throws IOException, ResourceException {
        this.client = new Client(Protocol.HTTP);
        Request request = new Request(Method.GET, this.uri);
        Response response = this.client.handle(request);
        AnnotatedResource11TestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        AnnotatedResource11TestCase.assertEquals((String)"asText-txt", (String)response.getEntity().getText());
        response.getEntity().release();
        request = new Request(Method.POST, this.uri);
        response = this.client.handle(request);
        AnnotatedResource11TestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        AnnotatedResource11TestCase.assertEquals((String)"accept", (String)response.getEntity().getText());
        response.getEntity().release();
    }

    private static class TestApplication
    extends Application {
        private TestApplication() {
        }

        public Restlet createInboundRoot() {
            Router router = new Router(this.getContext());
            router.attach("/test", MyResource11.class);
            return router;
        }
    }
}

