/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.service;

import java.util.ArrayList;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.representation.Variant;
import org.restlet.service.ConnegService;
import org.restlet.service.MetadataService;
import org.restlet.test.RestletTestCase;

public class ConnegServiceTestCase
extends RestletTestCase {
    public void testStrict() {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        Variant variant = new Variant(MediaType.APPLICATION_XML);
        variants.add(variant);
        Request request = new Request();
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.APPLICATION_JSON));
        MetadataService metadataService = new MetadataService();
        ConnegService connegService = new ConnegService();
        Variant preferedVariant = connegService.getPreferredVariant(variants, request, metadataService);
        ConnegServiceTestCase.assertNotNull((Object)preferedVariant);
        ConnegServiceTestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)preferedVariant.getMediaType());
        connegService.setStrict(true);
        preferedVariant = connegService.getPreferredVariant(variants, request, metadataService);
        ConnegServiceTestCase.assertNull((Object)preferedVariant);
        variant = new Variant(MediaType.APPLICATION_JSON);
        variants.add(variant);
        preferedVariant = connegService.getPreferredVariant(variants, request, metadataService);
        ConnegServiceTestCase.assertNotNull((Object)preferedVariant);
        ConnegServiceTestCase.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)preferedVariant.getMediaType());
    }
}

