/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.component.ComponentHelper;
import org.restlet.engine.component.ComponentXmlParser;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Finder;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;
import org.restlet.service.LogService;
import org.restlet.service.RealmService;
import org.restlet.service.StatusService;
import org.restlet.util.ClientList;
import org.restlet.util.ServerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Restlet {
    private final ClientList clients;
    private volatile VirtualHost defaultHost;
    private volatile RestletHelper<Component> helper;
    private final List<VirtualHost> hosts = new CopyOnWriteArrayList<VirtualHost>();
    private volatile Router internalRouter;
    private volatile LogService logService;
    private final ServerList servers;
    private volatile RealmService realmService;
    private volatile StatusService statusService;

    public static void main(String[] args) throws Exception {
        try {
            if (args == null || args.length != 1) {
                System.err.println("Can't launch the component. Requires the path to an XML configuration file.\n");
            } else {
                new Component(LocalReference.createFileReference(args[0])).start();
            }
        }
        catch (Exception e) {
            System.err.println("Can't launch the component.\nAn unexpected exception occurred:");
            e.printStackTrace(System.err);
        }
    }

    public Component() {
        this.clients = new ClientList(null);
        this.servers = new ServerList(null, this);
        if (Engine.getInstance() != null) {
            this.helper = new ComponentHelper(this);
            if (this.helper != null) {
                this.defaultHost = new VirtualHost(this.getContext().createChildContext());
                this.internalRouter = new Router(this.getContext().createChildContext()){

                    @Override
                    public Route attach(Restlet target) {
                        if (target.getContext() == null) {
                            target.setContext(this.getContext().createChildContext());
                        }
                        return super.attach(target);
                    }

                    @Override
                    public Route attach(String uriPattern, Restlet target) {
                        if (target.getContext() == null) {
                            target.setContext(this.getContext().createChildContext());
                        }
                        return super.attach(uriPattern, target);
                    }

                    @Override
                    public Route attachDefault(Restlet defaultTarget) {
                        if (defaultTarget.getContext() == null) {
                            defaultTarget.setContext(this.getContext().createChildContext());
                        }
                        return super.attachDefault(defaultTarget);
                    }

                    @Override
                    public Finder createFinder(Class<?> targetClass) {
                        Finder result = super.createFinder(targetClass);
                        result.setContext(this.getContext().createChildContext());
                        return result;
                    }
                };
                this.logService = new LogService(true);
                this.realmService = new RealmService(true);
                this.statusService = new StatusService(true);
                this.clients.setContext(this.getContext());
                this.servers.setContext(this.getContext());
            }
        }
    }

    public Component(Reference xmlConfigReference) {
        this();
        Representation xmlConfigRepresentation = null;
        if (xmlConfigReference != null) {
            Protocol protocol = xmlConfigReference.getSchemeProtocol();
            if (Protocol.FILE.equals(protocol)) {
                xmlConfigRepresentation = new FileRepresentation(new LocalReference(xmlConfigReference).getFile(), MediaType.TEXT_XML);
            } else {
                Response response = new Client(protocol).get(xmlConfigReference);
                if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                    xmlConfigRepresentation = response.getEntity();
                }
            }
        }
        if (xmlConfigRepresentation != null) {
            new ComponentXmlParser(this, xmlConfigRepresentation).parse();
        } else {
            this.getLogger().log(Level.WARNING, "Unable to get the Component XML configuration located at this URI: " + xmlConfigReference);
        }
    }

    public Component(Representation xmlConfigRepresentation) {
        this();
        if (xmlConfigRepresentation != null) {
            new ComponentXmlParser(this, xmlConfigRepresentation).parse();
        } else {
            this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.");
        }
    }

    public ClientList getClients() {
        return this.clients;
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private RestletHelper<Component> getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        return this.hosts;
    }

    public Router getInternalRouter() {
        return this.internalRouter;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public RealmService getRealmService() {
        return this.realmService;
    }

    public ServerList getServers() {
        return this.servers;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public synchronized void setClients(ClientList clients) {
        this.clients.clear();
        if (clients != null) {
            this.clients.addAll(clients);
        }
    }

    public void setDefaultHost(VirtualHost defaultHost) {
        this.defaultHost = defaultHost;
    }

    public synchronized void setHosts(List<VirtualHost> hosts) {
        this.hosts.clear();
        if (hosts != null) {
            this.hosts.addAll(hosts);
        }
    }

    public void setInternalRouter(Router internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public void setRealmService(RealmService securityService) {
        this.realmService = securityService;
    }

    public synchronized void setServers(ServerList servers) {
        this.servers.clear();
        if (servers != null) {
            this.servers.addAll(servers);
        }
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            this.startClients();
            this.startServers();
            this.startHelper();
            this.startServices();
            super.start();
        }
    }

    protected synchronized void startClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.start();
            }
        }
    }

    protected synchronized void startHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    protected synchronized void startServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.start();
            }
        }
    }

    protected synchronized void startServices() throws Exception {
        if (this.getLogService() != null) {
            this.getLogService().start();
        }
        if (this.getStatusService() != null) {
            this.getStatusService().start();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.stopHelper();
        this.stopServers();
        this.stopClients();
        this.stopServices();
        super.stop();
    }

    protected synchronized void stopClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
    }

    protected synchronized void stopHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
    }

    protected synchronized void stopServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
    }

    protected synchronized void stopServices() throws Exception {
        if (this.getLogService() != null) {
            this.getLogService().stop();
        }
        if (this.getStatusService() != null) {
            this.getStatusService().stop();
        }
    }

    public synchronized void updateHosts() throws Exception {
        this.getHelper().update();
    }
}

