/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.Iterator;
import org.restlet.Component;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.TemplateDispatcher;
import org.restlet.engine.component.ComponentContext;
import org.restlet.routing.VirtualHost;

public class ComponentClientDispatcher
extends TemplateDispatcher {
    public ComponentClientDispatcher(ComponentContext componentContext) {
        super(componentContext);
    }

    protected void doHandle(Request request, Response response) {
        super.doHandle(request, response);
        Protocol protocol = request.getProtocol();
        if (protocol.equals(Protocol.RIAP)) {
            LocalReference cr = new LocalReference(request.getResourceRef());
            Component component = this.getComponent();
            if (component != null) {
                if (cr.getRiapAuthorityType() == 5) {
                    request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                    component.getInternalRouter().handle(request, response);
                } else if (cr.getRiapAuthorityType() == 6) {
                    VirtualHost host = null;
                    VirtualHost currentHost = null;
                    Integer hostHashCode = VirtualHost.getCurrent();
                    Iterator<VirtualHost> hostIter = this.getComponent().getHosts().iterator();
                    while (host == null && hostIter.hasNext()) {
                        currentHost = hostIter.next();
                        if (currentHost.hashCode() != hostHashCode.intValue()) continue;
                        host = currentHost;
                    }
                    if (host == null && component.getDefaultHost() != null && component.getDefaultHost().hashCode() == hostHashCode.intValue()) {
                        host = component.getDefaultHost();
                    }
                    if (host != null) {
                        request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                        host.handle(request, response);
                    } else {
                        this.getLogger().warning("No virtual host is available to route the RIAP Host request.");
                    }
                } else {
                    this.getLogger().warning("Unknown RIAP authority. Only \"component\" is supported.");
                }
            } else {
                this.getLogger().warning("No component is available to route the RIAP request.");
            }
        } else {
            this.getComponentContext().getComponentHelper().getClientRouter().handle(request, response);
        }
    }

    private Component getComponent() {
        Component result = null;
        if (this.getComponentContext() != null && this.getComponentContext().getComponentHelper() != null) {
            result = (Component)this.getComponentContext().getComponentHelper().getHelped();
        }
        return result;
    }

    private ComponentContext getComponentContext() {
        return (ComponentContext)this.getContext();
    }
}

