/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.util.DefaultSaxHandler;
import org.restlet.representation.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;
import org.restlet.util.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentXmlParser {
    private Component component;
    private Representation xmlConfiguration;

    private static boolean isParameter(Node domNode) {
        return domNode != null && "parameter".equals(domNode.getNodeName());
    }

    private static Parameter parseParameter(Node domNode) {
        Parameter result = null;
        if (!ComponentXmlParser.isParameter(domNode)) {
            return null;
        }
        Node nameNode = domNode.getAttributes().getNamedItem("name");
        Node valueNode = domNode.getAttributes().getNamedItem("value");
        if (nameNode != null && valueNode != null) {
            result = new Parameter(nameNode.getNodeValue(), valueNode.getNodeValue());
        }
        return result;
    }

    public ComponentXmlParser(Component component, Representation xmlConfiguration) {
        this.component = component;
        this.xmlConfiguration = xmlConfiguration;
    }

    private Route attach(Router router, String targetClassName, String uriPattern, boolean defaultRoute) {
        Route route;
        block12: {
            route = null;
            if (targetClassName != null) {
                try {
                    Class<?> targetClass = Engine.loadClass(targetClassName);
                    if (Resource.class.isAssignableFrom(targetClass)) {
                        Class<?> resourceClass = targetClass;
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, resourceClass) : router.attachDefault(resourceClass);
                        break block12;
                    }
                    if (ServerResource.class.isAssignableFrom(targetClass)) {
                        Class<?> resourceClass = targetClass;
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, resourceClass) : router.attachDefault(resourceClass);
                        break block12;
                    }
                    Restlet target = null;
                    try {
                        target = (Restlet)targetClass.getConstructor(Context.class).newInstance(this.getComponent().getContext().createChildContext());
                    }
                    catch (NoSuchMethodException e) {
                        this.getLogger().log(Level.FINE, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of type Context. The empty constructor and the context setter will be used instead: " + targetClassName, e);
                        target = (Restlet)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        target.setContext(this.getComponent().getContext().createChildContext());
                    }
                    if (target != null) {
                        route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
                }
                catch (InstantiationException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
                }
                catch (NoSuchMethodException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
                }
                catch (InvocationTargetException e) {
                    this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
                }
            }
        }
        return route;
    }

    private Route attachWithDescriptor(Router router, String targetDescriptor, String uriPattern, boolean defaultRoute) {
        Route route = null;
        String targetClassName = null;
        try {
            targetClassName = "org.restlet.ext.wadl.WadlApplication";
            Class<?> targetClass = Engine.loadClass(targetClassName);
            Response response = this.getComponent().getContext().getClientDispatcher().get(targetDescriptor);
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                Representation representation = response.getEntity();
                Application target = (Application)targetClass.getConstructor(Context.class, Representation.class).newInstance(this.getComponent().getContext().createChildContext(), representation);
                if (target != null) {
                    route = uriPattern != null && !defaultRoute ? router.attach(uriPattern, target) : router.attachDefault(target);
                }
            } else {
                this.getLogger().log(Level.WARNING, "The target descriptor has not been found or is not available, or no client supporting the URI's protocol has been defined on this component. " + targetDescriptor);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().log(Level.WARNING, "Couldn't find the target class. Please check that your classpath includes " + targetClassName, e);
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check this class has an empty constructor " + targetClassName, e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. Please check that you have to proper access rights to " + targetClassName, e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.WARNING, "Couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + targetClassName, e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.WARNING, "Couldn't instantiate the target class. An exception was thrown while creating " + targetClassName, e);
        }
        return route;
    }

    private boolean getBoolean(Node node, boolean defaultValue) {
        boolean value = defaultValue;
        if (node != null) {
            try {
                value = Boolean.parseBoolean(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Component getComponent() {
        return this.component;
    }

    private float getFloat(Node node, float defaultValue) {
        float value = defaultValue;
        if (node != null) {
            try {
                value = Float.parseFloat(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private int getInt(Node node, int defaultValue) {
        int value = defaultValue;
        if (node != null) {
            try {
                value = Integer.parseInt(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Logger getLogger() {
        return this.getComponent().getLogger();
    }

    private long getLong(Node node, long defaultValue) {
        long value = defaultValue;
        if (node != null) {
            try {
                value = Long.parseLong(node.getNodeValue());
            }
            catch (Exception e) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Protocol getProtocol(String scheme) {
        Protocol protocol = Protocol.valueOf(scheme);
        if (protocol == null) {
            protocol = new Protocol(scheme);
        }
        return protocol;
    }

    private Representation getXmlConfiguration() {
        return this.xmlConfiguration;
    }

    public void parse() {
        block30: {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(true);
                dbf.setXIncludeAware(true);
                DefaultSaxHandler handler = new DefaultSaxHandler();
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setErrorHandler(handler);
                db.setEntityResolver(handler);
                Document document = db.parse(this.getXmlConfiguration().getStream());
                if ("component".equals(document.getFirstChild().getNodeName())) {
                    NodeList childNodes = document.getFirstChild().getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node item;
                        Node childNode = childNodes.item(i);
                        if ("client".equals(childNode.getNodeName())) {
                            item = childNode.getAttributes().getNamedItem("protocol");
                            Client client = null;
                            if (item == null) {
                                item = childNode.getAttributes().getNamedItem("protocols");
                                if (item != null) {
                                    String[] protocols = item.getNodeValue().split(" ");
                                    ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                                    for (String protocol : protocols) {
                                        protocolsList.add(this.getProtocol(protocol));
                                    }
                                    client = new Client(new Context(), protocolsList);
                                }
                            } else {
                                client = new Client(new Context(), this.getProtocol(item.getNodeValue()));
                            }
                            if (client == null) continue;
                            this.getComponent().getClients().add(client);
                            for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                                Parameter p;
                                Node childNode2 = childNode.getChildNodes().item(j);
                                if (!ComponentXmlParser.isParameter(childNode2) || (p = ComponentXmlParser.parseParameter(childNode2)) == null) continue;
                                client.getContext().getParameters().add(p);
                            }
                            continue;
                        }
                        if ("server".equals(childNode.getNodeName())) {
                            String address;
                            item = childNode.getAttributes().getNamedItem("protocol");
                            Node portNode = childNode.getAttributes().getNamedItem("port");
                            Node addressNode = childNode.getAttributes().getNamedItem("address");
                            Server server = null;
                            if (item == null) {
                                item = childNode.getAttributes().getNamedItem("protocols");
                                if (item != null) {
                                    String[] protocols = item.getNodeValue().split(" ");
                                    ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
                                    for (String protocol : protocols) {
                                        protocolsList.add(this.getProtocol(protocol));
                                    }
                                    int port = this.getInt(portNode, -1);
                                    if (port == -1) {
                                        this.getLogger().warning("Please specify a port when defining a list of protocols.");
                                    } else {
                                        server = new Server(new Context(), protocolsList, this.getInt(portNode, -1), this.getComponent().getServers().getTarget());
                                    }
                                }
                            } else {
                                Protocol protocol = this.getProtocol(item.getNodeValue());
                                server = new Server(new Context(), protocol, this.getInt(portNode, protocol.getDefaultPort()), this.getComponent().getServers().getTarget());
                            }
                            if (server == null) continue;
                            if (addressNode != null && (address = addressNode.getNodeValue()) != null) {
                                server.setAddress(address);
                            }
                            for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                                Parameter p;
                                Node childNode2 = childNode.getChildNodes().item(j);
                                if (!ComponentXmlParser.isParameter(childNode2) || (p = ComponentXmlParser.parseParameter(childNode2)) == null) continue;
                                server.getContext().getParameters().add(p);
                            }
                            this.getComponent().getServers().add(server);
                            continue;
                        }
                        if (ComponentXmlParser.isParameter(childNode)) {
                            Parameter p = ComponentXmlParser.parseParameter(childNode);
                            if (p == null) continue;
                            this.getComponent().getContext().getParameters().add(p);
                            continue;
                        }
                        if ("defaultHost".equals(childNode.getNodeName())) {
                            this.parseHost(this.getComponent().getDefaultHost(), childNode);
                            continue;
                        }
                        if ("host".equals(childNode.getNodeName())) {
                            VirtualHost host = new VirtualHost(this.getComponent().getContext());
                            this.parseHost(host, childNode);
                            this.getComponent().getHosts().add(host);
                            continue;
                        }
                        if ("internalRouter".equals(childNode.getNodeName())) {
                            this.parseRouter(this.getComponent().getInternalRouter(), childNode);
                            continue;
                        }
                        if ("logService".equals(childNode.getNodeName())) {
                            item = childNode.getAttributes().getNamedItem("logFormat");
                            if (item != null) {
                                this.getComponent().getLogService().setLogFormat(item.getNodeValue());
                            }
                            if ((item = childNode.getAttributes().getNamedItem("loggerName")) != null) {
                                this.getComponent().getLogService().setLoggerName(item.getNodeValue());
                            }
                            if ((item = childNode.getAttributes().getNamedItem("enabled")) != null) {
                                this.getComponent().getLogService().setEnabled(this.getBoolean(item, true));
                            }
                            if ((item = childNode.getAttributes().getNamedItem("identityCheck")) == null) continue;
                            this.getComponent().getLogService().setIdentityCheck(this.getBoolean(item, true));
                            continue;
                        }
                        if (!"statusService".equals(childNode.getNodeName())) continue;
                        item = childNode.getAttributes().getNamedItem("contactEmail");
                        if (item != null) {
                            this.getComponent().getStatusService().setContactEmail(item.getNodeValue());
                        }
                        if ((item = childNode.getAttributes().getNamedItem("enabled")) != null) {
                            this.getComponent().getStatusService().setEnabled(this.getBoolean(item, true));
                        }
                        if ((item = childNode.getAttributes().getNamedItem("homeRef")) != null) {
                            this.getComponent().getStatusService().setHomeRef(new Reference(item.getNodeValue()));
                        }
                        if ((item = childNode.getAttributes().getNamedItem("overwrite")) == null) continue;
                        this.getComponent().getStatusService().setOverwrite(this.getBoolean(item, true));
                    }
                    break block30;
                }
                this.getLogger().log(Level.WARNING, "Unable to find the root \"component\" node in the XML configuration.");
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.", e);
            }
        }
    }

    private void parseHost(VirtualHost host, Node hostNode) {
        this.parseRouter(host, hostNode);
        Node item = hostNode.getAttributes().getNamedItem("hostDomain");
        if (item != null && item.getNodeValue() != null) {
            host.setHostDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostPort")) != null && item.getNodeValue() != null) {
            host.setHostPort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("hostScheme")) != null && item.getNodeValue() != null) {
            host.setHostScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("name")) != null && item.getNodeValue() != null) {
            host.setName(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceDomain")) != null && item.getNodeValue() != null) {
            host.setResourceDomain(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourcePort")) != null && item.getNodeValue() != null) {
            host.setResourcePort(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("resourceScheme")) != null && item.getNodeValue() != null) {
            host.setResourceScheme(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverAddress")) != null && item.getNodeValue() != null) {
            host.setServerAddress(item.getNodeValue());
        }
        if ((item = hostNode.getAttributes().getNamedItem("serverPort")) != null && item.getNodeValue() != null) {
            host.setServerPort(item.getNodeValue());
        }
    }

    private void parseRouter(Router router, Node routerNode) {
        Node item = routerNode.getAttributes().getNamedItem("defaultMatchingMode");
        if (item != null) {
            router.setDefaultMatchingMode(this.getInt(item, this.getComponent().getInternalRouter().getDefaultMatchingMode()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("defaultMatchingQuery")) != null) {
            router.setDefaultMatchQuery(this.getBoolean(item, this.getComponent().getInternalRouter().getDefaultMatchQuery()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("maxAttempts")) != null) {
            router.setMaxAttempts(this.getInt(item, this.getComponent().getInternalRouter().getMaxAttempts()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("routingMode")) != null) {
            router.setRoutingMode(this.getInt(item, this.getComponent().getInternalRouter().getRoutingMode()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("requiredScore")) != null) {
            router.setRequiredScore(this.getFloat(item, this.getComponent().getInternalRouter().getRequiredScore()));
        }
        if ((item = routerNode.getAttributes().getNamedItem("retryDelay")) != null) {
            router.setRetryDelay(this.getLong(item, this.getComponent().getInternalRouter().getRetryDelay()));
        }
        this.setAttach(router, routerNode);
    }

    private void setAttach(Router router, Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (ComponentXmlParser.isParameter(childNode)) {
                Parameter p = ComponentXmlParser.parseParameter(childNode);
                if (p == null) continue;
                router.getContext().getParameters().add(p);
                continue;
            }
            if (!"attach".equals(childNode.getNodeName())) continue;
            String uriPattern = null;
            Node item = childNode.getAttributes().getNamedItem("uriPattern");
            uriPattern = item != null ? item.getNodeValue() : "";
            item = childNode.getAttributes().getNamedItem("default");
            boolean bDefault = this.getBoolean(item, false);
            Context oldContext = router.getContext();
            router.setContext(new Context());
            Route route = null;
            item = childNode.getAttributes().getNamedItem("targetClass");
            if (item != null) {
                route = this.attach(router, item.getNodeValue(), uriPattern, bDefault);
            } else {
                item = childNode.getAttributes().getNamedItem("targetDescriptor");
                if (item != null) {
                    route = this.attachWithDescriptor(router, item.getNodeValue(), uriPattern, bDefault);
                } else {
                    this.getLogger().log(Level.WARNING, "Both targetClass name and targetDescriptor are missing. Couldn't attach a new route.");
                }
            }
            if (route != null) {
                Template template = route.getTemplate();
                item = childNode.getAttributes().getNamedItem("matchingMode");
                template.setMatchingMode(this.getInt(item, 1));
                item = childNode.getAttributes().getNamedItem("defaultVariableType");
                template.getDefaultVariable().setType(this.getInt(item, 14));
                NodeList childNodes2 = childNode.getChildNodes();
                for (int j = 0; j < childNodes2.getLength(); ++j) {
                    Parameter p;
                    Node aNode = childNodes2.item(j);
                    if (!ComponentXmlParser.isParameter(aNode) || (p = ComponentXmlParser.parseParameter(aNode)) == null) continue;
                    route.getContext().getParameters().add(p);
                }
            }
            router.setContext(oldContext);
        }
    }
}

