/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;

public class HostRoute
extends Route {
    public HostRoute(Router router, VirtualHost target) {
        super(router, "", (Restlet)target);
    }

    protected int beforeHandle(Request request, Response response) {
        request.getResourceRef().setBaseRef(request.getHostRef());
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("New base URI: " + request.getResourceRef().getBaseRef());
            this.getLogger().fine("New remaining part: " + request.getResourceRef().getRemainingPart());
        }
        return 0;
    }

    public VirtualHost getVirtualHost() {
        return (VirtualHost)this.getNext();
    }

    private boolean matches(String regex, String formattedString) {
        return Pattern.compile(regex, 2).matcher(formattedString).matches();
    }

    public float score(Request request, Response response) {
        float result = 0.0f;
        String hostDomain = "";
        String hostPort = "";
        String hostScheme = "";
        if (request.getHostRef() != null) {
            int basePortValue;
            hostDomain = request.getHostRef().getHostDomain();
            if (hostDomain == null) {
                hostDomain = "";
            }
            if ((basePortValue = request.getHostRef().getHostPort()) == -1) {
                basePortValue = request.getHostRef().getSchemeProtocol().getDefaultPort();
            }
            hostPort = Integer.toString(basePortValue);
            hostScheme = request.getHostRef().getScheme();
            if (hostScheme == null) {
                hostScheme = "";
            }
        }
        if (request.getResourceRef() != null) {
            String serverAddress;
            int resourcePortValue;
            String resourceDomain = request.getResourceRef().getHostDomain();
            if (resourceDomain == null) {
                resourceDomain = "";
            }
            if ((resourcePortValue = request.getResourceRef().getHostPort()) == -1) {
                resourcePortValue = request.getResourceRef().getSchemeProtocol().getDefaultPort();
            }
            String resourcePort = Integer.toString(resourcePortValue);
            String resourceScheme = request.getResourceRef().getScheme();
            if (resourceScheme == null) {
                resourceScheme = "";
            }
            if ((serverAddress = response.getServerInfo().getAddress()) == null) {
                serverAddress = "";
            }
            String serverPort = "";
            if (response.getServerInfo().getPort() != -1) {
                serverPort = Integer.toString(response.getServerInfo().getPort());
            }
            if (this.matches(this.getVirtualHost().getHostDomain(), hostDomain) && this.matches(this.getVirtualHost().getHostPort(), hostPort) && this.matches(this.getVirtualHost().getHostScheme(), hostScheme) && this.matches(this.getVirtualHost().getResourceDomain(), resourceDomain) && this.matches(this.getVirtualHost().getResourcePort(), resourcePort) && this.matches(this.getVirtualHost().getResourceScheme(), resourceScheme) && this.matches(this.getVirtualHost().getServerAddress(), serverAddress) && this.matches(this.getVirtualHost().getServerPort(), serverPort)) {
                result = 1.0f;
            }
        }
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Call score for the \"" + this.getVirtualHost().getName() + "\" host: " + result);
        }
        return result;
    }

    public void setNext(VirtualHost next) {
        super.setNext(next);
    }
}

