/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.RepresentationInfo;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.UniformResource;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerResource
extends UniformResource {
    private boolean annotated = true;
    private volatile List<AnnotationInfo> annotations = null;
    private boolean conditional = true;
    private boolean existing = true;
    private boolean introspected = false;
    private boolean negotiated = true;
    private volatile Map<Method, Object> variants = null;

    protected Representation delete() throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation delete(Variant variant) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation describeVariants() {
        Representation result = null;
        return result;
    }

    protected Representation doConditionalHandle() throws ResourceException {
        Representation result = null;
        if (this.getConditions().hasSome()) {
            if (!this.isExisting() && this.getConditions().getMatch().contains(Tag.ALL)) {
                this.setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED, "A non existing resource can't match any tag.");
            } else {
                RepresentationInfo resultInfo = null;
                resultInfo = this.isNegotiated() ? this.doGetInfo(this.getPreferredVariant(Method.GET)) : this.doGetInfo();
                if (resultInfo == null) {
                    if (this.getStatus() == null || this.getStatus().isSuccess() && !Status.SUCCESS_NO_CONTENT.equals(this.getStatus())) {
                        this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    }
                } else {
                    Status status = this.getConditions().getStatus(this.getMethod(), resultInfo);
                    if (status != null) {
                        this.setStatus(status);
                    }
                }
                if (this.getStatus() != null && this.getStatus().isSuccess()) {
                    result = (Method.GET.equals(this.getMethod()) || Method.HEAD.equals(this.getMethod())) && resultInfo instanceof Representation ? (Representation)resultInfo : (this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle());
                }
            }
        } else {
            result = this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle();
        }
        return result;
    }

    private RepresentationInfo doGetInfo() throws ResourceException {
        RepresentationInfo result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.GET);
        result = annotationInfo != null ? this.doHandle(annotationInfo) : this.getInfo();
        return result;
    }

    private RepresentationInfo doGetInfo(Variant variant) throws ResourceException {
        RepresentationInfo result = null;
        result = variant instanceof VariantInfo ? this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant) : (variant instanceof RepresentationInfo ? (RepresentationInfo)variant : this.getInfo(variant));
        return result;
    }

    protected Representation doHandle() throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else {
            AnnotationInfo annotationInfo = this.getAnnotation(method);
            if (annotationInfo != null) {
                result = this.doHandle(annotationInfo);
            } else if (method.equals(Method.PUT)) {
                result = this.put(this.getRequestEntity());
            } else if (this.isExisting()) {
                if (method.equals(Method.GET)) {
                    result = this.get();
                } else if (method.equals(Method.POST)) {
                    result = this.post(this.getRequestEntity());
                } else if (method.equals(Method.DELETE)) {
                    result = this.delete();
                } else if (method.equals(Method.HEAD)) {
                    result = this.head();
                } else if (method.equals(Method.OPTIONS)) {
                    result = this.options();
                } else {
                    this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                }
            } else {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return result;
    }

    private Representation doHandle(AnnotationInfo annotationInfo) throws ResourceException {
        Representation result = null;
        ConverterService cs = this.getConverterService();
        Class<?>[] parameterTypes = annotationInfo.getJavaParameterTypes();
        ArrayList parameters = null;
        Object resultObject = null;
        try {
            if (parameterTypes.length > 0) {
                parameters = new ArrayList();
                for (Class<?> parameterType : parameterTypes) {
                    if (this.getRequestEntity() != null) {
                        try {
                            parameters.add(cs.toObject(this.getRequestEntity(), parameterType, this));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            parameters.add(null);
                        }
                        continue;
                    }
                    parameters.add(null);
                }
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, parameters.toArray());
            } else {
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ResourceException) {
                throw (ResourceException)e.getTargetException();
            }
            throw new ResourceException(e.getTargetException());
        }
        if (resultObject != null) {
            result = cs.toRepresentation(resultObject);
        }
        return result;
    }

    private Representation doHandle(AnnotationInfo annotationInfo, Variant variant) throws ResourceException {
        Representation result = null;
        ConverterService cs = this.getConverterService();
        Object resultObject = null;
        try {
            if (annotationInfo.getJavaParameterTypes() != null && annotationInfo.getJavaParameterTypes().length > 0) {
                ArrayList<Variant> parameters = new ArrayList<Variant>();
                Object parameter = null;
                for (Class<?> param : annotationInfo.getJavaParameterTypes()) {
                    if (Variant.class.equals(param)) {
                        parameters.add(variant);
                        continue;
                    }
                    if (this.getRequestEntity().isAvailable()) {
                        try {
                            parameter = cs.toObject(this.getRequestEntity(), param, this);
                        }
                        catch (IOException e) {
                            parameter = null;
                        }
                        if (parameter == null) {
                            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
                        }
                    } else {
                        parameter = null;
                    }
                    parameters.add((Variant)parameter);
                }
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, parameters.toArray());
            } else {
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, new Object[0]);
            }
            result = cs.toRepresentation(resultObject, variant, this);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ResourceException) {
                throw (ResourceException)e.getTargetException();
            }
            throw new ResourceException(e.getTargetException());
        }
        return result;
    }

    protected Representation doHandle(Variant variant) throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else if (method.equals(Method.PUT)) {
            result = this.put(this.getRequestEntity(), variant);
        } else if (this.isExisting()) {
            if (method.equals(Method.GET)) {
                result = variant instanceof Representation ? (Representation)variant : this.get(variant);
            } else if (method.equals(Method.POST)) {
                result = this.post(this.getRequestEntity(), variant);
            } else if (method.equals(Method.DELETE)) {
                result = this.delete(variant);
            } else if (method.equals(Method.HEAD)) {
                result = variant instanceof Representation ? (Representation)variant : this.head(variant);
            } else if (method.equals(Method.OPTIONS)) {
                result = variant instanceof Representation ? (Representation)variant : this.options(variant);
            } else {
                this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }

    protected Representation doNegotiatedHandle() throws ResourceException {
        Representation result = null;
        List<Variant> variants = this.getAvailableVariants(this.getMethod());
        if (variants != null && !variants.isEmpty()) {
            Variant preferredVariant = this.getClientInfo().getPreferredVariant(variants, this.getApplication() == null ? new MetadataService() : this.getApplication().getMetadataService());
            if (preferredVariant == null) {
                this.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
                result = this.describeVariants();
            } else {
                this.updateDimensions();
                result = preferredVariant instanceof VariantInfo ? this.doHandle(((VariantInfo)preferredVariant).getAnnotationInfo(), preferredVariant) : this.doHandle(preferredVariant);
            }
        } else {
            result = this.doHandle();
        }
        return result;
    }

    protected Representation get() throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation get(Variant variant) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    private AnnotationInfo getAnnotation(Method method) {
        if (this.isAnnotated()) {
            return AnnotationUtils.getAnnotation(this.getAnnotations(), method);
        }
        return null;
    }

    private List<AnnotationInfo> getAnnotations() {
        if (this.isAnnotated() && !this.isIntrospected()) {
            this.annotations = AnnotationUtils.getAnnotationDescriptors(this.getClass());
            this.setIntrospected(true);
        }
        return this.annotations;
    }

    private List<Variant> getAvailableVariants(Method method) {
        List<Variant> methodVariants;
        ArrayList<VariantInfo> result = null;
        if (this.isAnnotated() && this.hasAnnotations()) {
            MetadataService ms;
            MetadataService metadataService = ms = this.getApplication() == null ? null : this.getApplication().getMetadataService();
            if (ms == null) {
                ms = new MetadataService();
            }
            ConverterService cs = this.getConverterService();
            List<? extends Variant> annoVariants = null;
            for (AnnotationInfo annotationInfo : this.annotations) {
                if (!method.equals(annotationInfo.getRestletMethod())) continue;
                if (annotationInfo.getValue() != null) {
                    List<Metadata> allMetadata = ms.getAllMetadata(annotationInfo.getValue());
                    for (Metadata metadata : allMetadata) {
                        if (!(metadata instanceof MediaType) || (annoVariants = cs.getVariants(annotationInfo.getJavaReturnType(), new Variant((MediaType)metadata))) == null) continue;
                        if (result == null) {
                            result = new ArrayList();
                        }
                        for (VariantInfo variantInfo : annoVariants) {
                            variantInfo.setAnnotationInfo(annotationInfo);
                            result.add(variantInfo);
                        }
                    }
                    continue;
                }
                annoVariants = cs.getVariants(annotationInfo.getJavaReturnType(), null);
                if (annoVariants == null) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                for (VariantInfo variantInfo : annoVariants) {
                    variantInfo.setAnnotationInfo(annotationInfo);
                    result.add(variantInfo);
                }
            }
        }
        if ((methodVariants = this.getVariants(this.getMethod())) != null) {
            if (result == null) {
                result = new ArrayList<VariantInfo>();
            }
            result.addAll(methodVariants);
        }
        return result;
    }

    private ConverterService getConverterService() {
        return this.getApplication() == null ? new ConverterService() : this.getApplication().getConverterService();
    }

    protected RepresentationInfo getInfo() throws ResourceException {
        return this.get();
    }

    protected RepresentationInfo getInfo(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public Variant getPreferredVariant(Method method) {
        Variant result = null;
        List<Variant> variants = this.getAvailableVariants(method);
        if (variants != null && !variants.isEmpty()) {
            result = this.getClientInfo().getPreferredVariant(variants, this.getApplication() == null ? null : this.getApplication().getMetadataService());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Method, Object> getVariants() {
        Map<Method, Object> v = this.variants;
        if (v == null) {
            ServerResource serverResource = this;
            synchronized (serverResource) {
                v = this.variants;
                if (v == null) {
                    this.variants = v = new TreeMap<Method, Object>();
                }
            }
        }
        return v;
    }

    public List<Variant> getVariants(Method method) {
        List<Variant> allVariants;
        ArrayList<Variant> result = null;
        Object object = this.getVariants().get(method);
        if (object != null) {
            List list;
            if (object instanceof Variant) {
                result = new ArrayList<Variant>();
                result.add((Variant)object);
            } else if (object instanceof MediaType) {
                result = new ArrayList();
                result.add(new Variant((MediaType)object));
            } else if (object instanceof List && !(list = (List)object).isEmpty()) {
                Object obj = list.get(0);
                if (obj instanceof Variant) {
                    result = new ArrayList();
                    result.addAll((List)object);
                } else if (obj instanceof MediaType) {
                    result = new ArrayList();
                    for (Object object2 : list) {
                        result.add(new Variant((MediaType)object2));
                    }
                }
            }
        }
        if (!Method.ALL.equals(method) && (allVariants = this.getVariants(Method.ALL)) != null) {
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(allVariants);
        }
        return result;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (!this.existing && this.getMethod().isSafe()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return result;
        }
        try {
            result = this.isConditional() ? this.doConditionalHandle() : (this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle());
            this.getResponse().setEntity(result);
            if (Status.CLIENT_ERROR_METHOD_NOT_ALLOWED.equals(this.getStatus())) {
                this.updateAllowedMethods();
            }
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
        return result;
    }

    private boolean hasAnnotations() {
        return this.getAnnotations() != null && !this.getAnnotations().isEmpty();
    }

    protected Representation head() throws ResourceException {
        return this.get();
    }

    protected Representation head(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public boolean isInRole(String roleName) {
        return this.getClientInfo().isInRole(this.getApplication().findRole(roleName));
    }

    private boolean isIntrospected() {
        return this.introspected;
    }

    public boolean isNegotiated() {
        return this.negotiated;
    }

    protected Representation options() throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation options(Variant variant) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation post(Representation entity) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation post(Representation entity, Variant variant) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation put(Representation representation) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    protected Representation put(Representation representation, Variant variant) throws ResourceException {
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    public void redirectPermanent(Reference targetRef) {
        this.getResponse().redirectPermanent(targetRef);
    }

    public void redirectPermanent(String targetUri) {
        this.getResponse().redirectPermanent(targetUri);
    }

    public void redirectSeeOther(Reference targetRef) {
        this.getResponse().redirectSeeOther(targetRef);
    }

    public void redirectSeeOther(String targetUri) {
        this.getResponse().redirectSeeOther(targetUri);
    }

    public void redirectTemporary(Reference targetRef) {
        this.getResponse().redirectTemporary(targetRef);
    }

    public void redirectTemporary(String targetUri) {
        this.getResponse().redirectTemporary(targetUri);
    }

    public void setAllowedMethods(Set<Method> allowedMethods) {
        this.getResponse().setAllowedMethods(allowedMethods);
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    public void setChallengeRequests(List<ChallengeRequest> requests) {
        this.getResponse().setChallengeRequests(requests);
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public void setCookieSettings(Series<CookieSetting> cookieSettings) {
        this.getResponse().setCookieSettings(cookieSettings);
    }

    public void setDimensions(Set<Dimension> dimensions) {
        this.getResponse().setDimensions(dimensions);
    }

    public void setExisting(boolean exists) {
        this.existing = exists;
    }

    private void setIntrospected(boolean introspected) {
        this.introspected = introspected;
    }

    public void setLocationRef(Reference locationRef) {
        this.getResponse().setLocationRef(locationRef);
    }

    public void setLocationRef(String locationUri) {
        this.getResponse().setLocationRef(locationUri);
    }

    public void setNegotiated(boolean negotiateContent) {
        this.negotiated = negotiateContent;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.getResponse().setServerInfo(serverInfo);
    }

    public void setStatus(Status status) {
        this.getResponse().setStatus(status);
    }

    public void setStatus(Status status, String message) {
        this.getResponse().setStatus(status, message);
    }

    public void setStatus(Status status, Throwable throwable) {
        this.getResponse().setStatus(status, throwable);
    }

    public void setStatus(Status status, Throwable throwable, String message) {
        this.getResponse().setStatus(status, throwable, message);
    }

    public void setVariants(Map<Method, Object> variants) {
        this.variants = variants;
    }

    protected void updateAllowedMethods() {
    }

    protected void updateDimensions() {
        this.getDimensions().add(Dimension.CHARACTER_SET);
        this.getDimensions().add(Dimension.ENCODING);
        this.getDimensions().add(Dimension.LANGUAGE);
        this.getDimensions().add(Dimension.MEDIA_TYPE);
    }
}

