/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.IOException;
import org.restlet.data.Status;
import org.restlet.data.Warning;
import org.restlet.engine.http.HeaderReader;
import org.restlet.engine.util.DateUtils;

public class WarningReader
extends HeaderReader {
    public WarningReader(String header) {
        super(header);
    }

    public void readQuotedString(Appendable buffer) throws IOException {
        int nextChar = this.read();
        while (nextChar != 34 && nextChar != -1) {
            nextChar = this.read();
        }
        if (nextChar == 34) {
            super.readQuotedString(buffer);
        }
    }

    public final boolean isValueSeparator(int character) {
        return character == 32;
    }

    public Warning readWarning() throws IOException {
        Warning result = new Warning();
        String code = this.readValue();
        String agent = this.readValue();
        String text = this.readQuotedString();
        String date = this.readQuotedString();
        if (code == null || agent == null || text == null) {
            throw new IOException("Warning header malformed.");
        }
        result.setStatus(Status.valueOf(Integer.parseInt(code)));
        result.setAgent(agent);
        result.setText(text);
        result.setDate(DateUtils.parse(date));
        return result;
    }
}

