/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.engine.Method;
import org.restlet.engine.resource.AnnotationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static final ConcurrentMap<Class<?>, List<AnnotationInfo>> cache = new ConcurrentHashMap();

    public static void clearCache() {
        cache.clear();
    }

    private static List<AnnotationInfo> addAnnotationDescriptors(List<AnnotationInfo> descriptors, Class<?> clazz) {
        List<AnnotationInfo> result = descriptors;
        if (result == null) {
            result = new CopyOnWriteArrayList<AnnotationInfo>();
        }
        for (java.lang.reflect.Method javaMethod : clazz.getMethods()) {
            for (Annotation annotation : javaMethod.getAnnotations()) {
                int endIndex;
                int startIndex;
                Method methodAnnotation = annotation.annotationType().getAnnotation(Method.class);
                if (methodAnnotation == null) continue;
                org.restlet.data.Method restletMethod = org.restlet.data.Method.valueOf(methodAnnotation.value());
                String toString = ((Object)annotation).toString();
                String value = toString.substring(startIndex = annotation.annotationType().getCanonicalName().length() + 8, endIndex = toString.length() - 1);
                if ("".equals(value)) {
                    value = null;
                }
                result.add(new AnnotationInfo(restletMethod, javaMethod, value));
            }
        }
        return result;
    }

    public static AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, java.lang.reflect.Method javaMethod) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.getJavaMethod().equals(javaMethod)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public static AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, org.restlet.data.Method restletMethod) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.getRestletMethod().equals(restletMethod)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public static List<AnnotationInfo> getAnnotationDescriptors(Class<?> clazz) {
        List<AnnotationInfo> result = (List<AnnotationInfo>)cache.get(clazz);
        if (result == null) {
            Class<?>[] interfaces;
            List<AnnotationInfo> prev = cache.putIfAbsent(clazz, result = AnnotationUtils.addAnnotationDescriptors(result, clazz));
            if (prev != null) {
                result = prev;
            }
            if ((interfaces = clazz.getInterfaces()) != null) {
                for (Class<?> interfaceClass : interfaces) {
                    result = AnnotationUtils.addAnnotationDescriptors(result, interfaceClass);
                }
            }
        }
        return result;
    }

    private AnnotationUtils() {
    }
}

