/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.restlet.Connector;
import org.restlet.engine.connector.BaseHelper;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionPool;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.OutboundWay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionHelper<T extends Connector>
extends BaseHelper<T> {
    private final Set<Connection<T>> connections = new CopyOnWriteArraySet<Connection<T>>();
    private volatile ConnectionPool<T> connectionPool = null;

    public ConnectionHelper(T connector, boolean clientSide) {
        super(connector, clientSide);
    }

    protected void checkin(Connection<?> connection) {
        connection.clear();
        if (this.isPooledConnection()) {
            this.getConnectionPool().checkin(connection);
        }
    }

    protected Connection<T> checkout(SocketChannel socketChannel, ConnectionController controller, SocketAddress socketAddress) throws IOException {
        Connection<T> result = null;
        if (this.isPooledConnection()) {
            result = (Connection<T>)this.getConnectionPool().checkout();
            result.reuse(socketChannel, controller, socketAddress);
        } else {
            result = this.createConnection(socketChannel, controller, socketAddress);
        }
        return result;
    }

    protected abstract Connection<T> createConnection(SocketChannel var1, ConnectionController var2, SocketAddress var3) throws IOException;

    public void createConnectionPool() {
        if (this.isPooledConnection()) {
            this.connectionPool = new ConnectionPool(this, this.getInitialConnections());
        }
    }

    public abstract InboundWay createInboundWay(Connection<T> var1);

    public abstract OutboundWay createOutboundWay(Connection<T> var1);

    @Override
    protected void doFinishStop() {
        super.doFinishStop();
        if (this.isPooledConnection()) {
            this.connectionPool = null;
        }
    }

    @Override
    protected void doGracefulStop() {
        super.doGracefulStop();
        for (Connection<T> connection : this.getConnections()) {
            connection.close(true);
        }
    }

    protected ConnectionPool<T> getConnectionPool() {
        return this.connectionPool;
    }

    protected Set<Connection<T>> getConnections() {
        return this.connections;
    }

    public int getInitialConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("initialConnections", "100"));
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "-1"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "-1"));
    }

    public int getSocketReceiveBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketReceiveBufferSize", "8192"));
    }

    public boolean isPersistingConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("persistingConnections", "true"));
    }

    public boolean isPipeliningConnections() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("pipeliningConnections", "false"));
    }

    public boolean isPooledConnection() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("pooledConnections", "true"));
    }

    public abstract boolean isProxying();

    public boolean isSocketReuseAddress() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketReuseAddress", "true"));
    }
}

