/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.restlet.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller {
    protected final ConnectionHelper<?> helper;
    protected boolean overloaded;
    protected boolean running;

    public Controller(ConnectionHelper<?> helper) {
        this.helper = helper;
        this.overloaded = false;
        this.running = false;
    }

    protected boolean controlHelper() {
        int i;
        boolean result = false;
        for (i = 0; i < this.getHelper().getInboundMessages().size(); ++i) {
            this.handleInbound(this.getHelper().getInboundMessages().poll());
        }
        for (i = 0; i < this.getHelper().getOutboundMessages().size(); ++i) {
            this.handleOutbound(this.getHelper().getOutboundMessages().poll());
        }
        return result;
    }

    protected void doInit() {
    }

    protected void doRelease() {
    }

    protected void doRun(long sleepTime) throws IOException {
        this.controlHelper();
    }

    protected void execute(Runnable task) {
        try {
            if (!this.isOverloaded() && this.getWorkerService() != null && !this.getWorkerService().isShutdown() && this.isRunning()) {
                this.getWorkerService().execute(task);
            }
        }
        catch (Exception e) {
            this.getHelper().getLogger().log(Level.WARNING, "Unable to execute a " + (this.getHelper().isClientSide() ? "client-side" : "server-side") + " controller task", e);
        }
    }

    protected ConnectionHelper<?> getHelper() {
        return this.helper;
    }

    protected ExecutorService getWorkerService() {
        return this.getHelper().getWorkerService();
    }

    protected abstract void handleInbound(Response var1);

    protected void handleInbound(final Response response, boolean synchronous) {
        if (response != null) {
            if (synchronous || !this.getHelper().isWorkerThreads()) {
                this.getHelper().handleInbound(response);
            } else {
                this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Controller.this.getHelper().handleInbound(response);
                        }
                        finally {
                            Engine.clearThreadLocalVariables();
                        }
                    }

                    public String toString() {
                        return "Handle inbound messages";
                    }
                });
            }
        }
    }

    protected abstract void handleOutbound(Response var1);

    protected void handleOutbound(final Response response, boolean synchronous) {
        if (response != null) {
            if (synchronous || !this.getHelper().isWorkerThreads()) {
                this.getHelper().handleOutbound(response);
            } else {
                this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Controller.this.getHelper().handleOutbound(response);
                        }
                        finally {
                            Engine.clearThreadLocalVariables();
                        }
                    }

                    public String toString() {
                        return "Handle outbound messages";
                    }
                });
            }
        }
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        this.doInit();
        this.setRunning(true);
        long sleepTime = this.getHelper().getControllerSleepTimeMs();
        while (this.isRunning()) {
            try {
                if (this.getHelper().isWorkerThreads()) {
                    if (this.isOverloaded() && !this.getHelper().isWorkerServiceOverloaded()) {
                        this.setOverloaded(false);
                        this.getHelper().getLogger().info("Connector overload ended. Accepting new work again");
                        this.getHelper().traceWorkerService();
                    } else if (this.getHelper().isWorkerServiceOverloaded()) {
                        this.setOverloaded(true);
                        this.getHelper().getLogger().info("Connector overload detected. Stop accepting new work");
                        this.getHelper().traceWorkerService();
                    }
                }
                this.doRun(sleepTime);
            }
            catch (Exception ex) {
                this.helper.getLogger().log(Level.WARNING, "Unexpected error while controlling connector", ex);
            }
        }
        this.doRelease();
    }

    public void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void shutdown() throws IOException {
        this.setRunning(false);
    }
}

