/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.header.HeaderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChallengeRequestReader
extends HeaderReader<ChallengeRequest> {
    public static void main(String[] args) throws Exception {
        String str = "Basic realm=\"Control Panel\"";
        ChallengeRequestReader r = new ChallengeRequestReader(str);
        ChallengeRequest c = r.readValue();
        System.out.println(c.getScheme());
        System.out.println(c.getRawValue());
        str = "Digest realm=\"Control Panel\", domain=\"/controlPanel\", nonce=\"15bb54af506016d4414a025d4c84e34c\", algorithm=MD5, qop=\"auth,auth-int\"";
        r = new ChallengeRequestReader(str);
        c = r.readValue();
        System.out.println(c.getScheme());
        System.out.println(c.getRawValue());
        str = "Negotiate";
        r = new ChallengeRequestReader(str);
        c = r.readValue();
        System.out.println(c.getScheme());
        System.out.println(c.getRawValue());
        str = "Basic realm=\"Control Panel\",Digest realm=\"Control Panel\", domain=\"/controlPanel\", nonce=\"15bb54af506016d4414a025d4c84e34c\", algorithm=MD5, qop=\"auth,auth-int\"";
        r = new ChallengeRequestReader(str);
        System.out.println("list");
        for (ChallengeRequest challengeRequest : r.readValues()) {
            System.out.println(challengeRequest.getScheme());
            System.out.println(challengeRequest.getRawValue());
        }
    }

    public ChallengeRequestReader(String header) {
        super(header);
    }

    @Override
    public ChallengeRequest readValue() throws IOException {
        ChallengeRequest result = null;
        this.skipSpaces();
        if (this.peek() != -1) {
            String scheme = this.readToken();
            result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme));
            this.skipSpaces();
            HeaderWriter<Parameter> w = new HeaderWriter<Parameter>(){

                @Override
                public HeaderWriter<Parameter> append(Parameter value) {
                    this.appendExtension(value);
                    return this;
                }
            };
            boolean stop = false;
            while (this.peek() != -1 && !stop) {
                boolean sepSkipped = this.skipValueSeparator();
                this.mark();
                this.readToken();
                int nextChar = this.read();
                this.reset();
                if (HeaderUtils.isSpace(nextChar)) {
                    stop = true;
                    continue;
                }
                if (sepSkipped) {
                    w.appendValueSeparator();
                }
                w.append(this.readParameter());
            }
            result.setRawValue(w.toString());
        }
        return result;
    }
}

